# 2021-09-21 Triage Log

A nice week: more improvements than regressions.

Triage done by **@pnkfelix**.
Revision range: [9f85cd6f2ab2769c16e89dcdddb3e11d9736b351..7743c9fadd64886d537966ba224b9c20e6014a59](https://perf.rust-lang.org/?start=9f85cd6f2ab2769c16e89dcdddb3e11d9736b351&end=7743c9fadd64886d537966ba224b9c20e6014a59&absolute=false&stat=instructions%3Au)

2 Regressions, 4 Improvements, 8 Mixed; ??? of them in rollups
44 comparisons made in total

#### Regressions

Point at argument instead of call for their obligations [#88719](https://github.com/rust-lang/rust/issues/88719)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=e4828d5b7f745a9e867a9b0cc7f080f287bcf55d&end=e36621057d9f497c822eb800934b5933c10510cf&stat=instructions:u) (up to 1.9% on `full` builds of `diesel`)


Rollup of 10 pull requests [#89047](https://github.com/rust-lang/rust/issues/89047)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=e0c38af27cb5f6f961809601b717d6afc3b190ee&end=207d9558d00dd5cc438a6418ba96912d396e2155&stat=instructions:u) (up to 1.9% on `incr-unchanged` builds of `webrender-wrench`)


#### Improvements

Avoid unnecessary formatting when trace log level is disabled [#88934](https://github.com/rust-lang/rust/issues/88934)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=78a46efff06558674b51c10d8d81758285746ab5&end=38e576423dc56a006ccf0b72e106f09bdea6efc2&stat=instructions:u) (up to -1.0% on `incr-full` builds of `derive`)


Fast reject for NeedsNonConstDrop [#88965](https://github.com/rust-lang/rust/issues/88965)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=a58db2e4ddbb2e0fa91c53c4901b52a7ef71ef2d&end=8e398f5ba77b283b529c0c61cc2313c4f82d61dd&stat=instructions:u) (up to -2.5% on `full` builds of `html5ever`)


Avoid codegen for Result::into_ok in lang_start [#88988](https://github.com/rust-lang/rust/issues/88988)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=5438ee424c004d7c89f16b9b1b95e899dbc87b25&end=6cdd42f9f8dd4e5e5ba0aa816bc4c99ab8b102f9&stat=instructions:u) (up to -4.4% on `incr-full` builds of `helloworld`)


Don't inline OnceCell initialization closures [#89031](https://github.com/rust-lang/rust/issues/89031)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=3bca7230ff1ec35db25f2547cf2e83a6f450e923&end=7a3d1a5f3dfeaf5177885fedd7db8ecc70670dc1&stat=instructions:u) (up to -0.9% on `full` builds of `helloworld`)


#### Mixed

Const drop [#88558](https://github.com/rust-lang/rust/issues/88558)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=c3c0f80d6081092faff801542dd82f0e2420152b&end=cdeba02ff71416e014f7130f75166890688be986&stat=instructions:u) (up to -1.7% on `full` builds of `externs`)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=c3c0f80d6081092faff801542dd82f0e2420152b&end=cdeba02ff71416e014f7130f75166890688be986&stat=instructions:u) (up to 2.7% on `full` builds of `html5ever`)
- Regression addressed by followup PRs [#88965](https://github.com/rust-lang/rust/issues/88965) (which has landed) and [#88963](https://github.com/rust-lang/rust/issues/88963) (which has not yet landed).

Introduce a fast path that avoids the `debug_tuple` abstraction when deriving Debug for unit-like enum variants. [#88832](https://github.com/rust-lang/rust/issues/88832)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=e36621057d9f497c822eb800934b5933c10510cf&end=78a46efff06558674b51c10d8d81758285746ab5&stat=instructions:u) (up to -4.5% on `full` builds of `stm32f4`)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=e36621057d9f497c822eb800934b5933c10510cf&end=78a46efff06558674b51c10d8d81758285746ab5&stat=instructions:u) (up to 1.3% on `incr-unchanged` builds of `ctfe-stress-4`)
- Already [triaged by simulacrum](https://github.com/rust-lang/rust/pull/88832#issuecomment-919967148), noting that the instruction count regressions are justified because the same benchmarks do not regress in cycles.

Remove concept of 'completion' from the projection cache [#88945](https://github.com/rust-lang/rust/issues/88945)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=1c03f0d0ba4fee54b7aa458f4d3ad989d8bf7b34&end=e0c38af27cb5f6f961809601b717d6afc3b190ee&stat=instructions:u) (up to -0.3% on `incr-unchanged` builds of `helloworld`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=1c03f0d0ba4fee54b7aa458f4d3ad989d8bf7b34&end=e0c38af27cb5f6f961809601b717d6afc3b190ee&stat=instructions:u) (up to 0.8% on `full` builds of `wg-grammar`)
- Wrote [comment](https://github.com/rust-lang/rust/pull/88945#issuecomment-924384164) noting that scope of regression was limited but might still be worth investigating, at least briefly.

Simplify lazy DefPathHash decoding by using an on-disk hash table. [#82183](https://github.com/rust-lang/rust/issues/82183)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=23afad6e7f0ff17320411a274f3a3beb92452235&end=d6cd2c6c877110748296760aefddc21a0ea1d316&stat=instructions:u) (up to -7.7% on `incr-unchanged` builds of `deeply-nested`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=23afad6e7f0ff17320411a274f3a3beb92452235&end=d6cd2c6c877110748296760aefddc21a0ea1d316&stat=instructions:u) (up to 1.9% on `incr-full` builds of `coercions`)
- [Triaged](https://github.com/rust-lang/rust/pull/82183#issuecomment-924367405): the wins here massively outweigh the few slight losses.

Gather module items after lowering. [#88703](https://github.com/rust-lang/rust/issues/88703)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=697118d23eaa5d59940befabedcafbaceaf61a1c&end=7b5f95270f1ef7118ef4d3b47428054d23113ad5&stat=instructions:u) (up to -1.3% on `incr-unchanged` builds of `ctfe-stress-4`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=697118d23eaa5d59940befabedcafbaceaf61a1c&end=7b5f95270f1ef7118ef4d3b47428054d23113ad5&stat=instructions:u) (up to 0.8% on `incr-unchanged` builds of `tuple-stress`)
https://github.com/rust-lang/rust/issues/88703
- Wrote [wishy-washy comment](https://github.com/rust-lang/rust/pull/88703#issuecomment-924388131) noting that this is indeed a mixed result and it may not be worth investigating, but didn't pull trigger on adding triaged label.

Querify `FnAbi::of_{fn_ptr,instance}` as `fn_abi_of_{fn_ptr,instance}`. [#88575](https://github.com/rust-lang/rust/issues/88575)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=5ecc8ad8462574354a55162a0c16b10eb95e3e70&end=91198820d7e697def79177c022b5e98b3d482ddc&stat=instructions:u) (up to -1.0% on `full` builds of `regression-31157`)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=5ecc8ad8462574354a55162a0c16b10eb95e3e70&end=91198820d7e697def79177c022b5e98b3d482ddc&stat=instructions:u) (up to 1.4% on `incr-unchanged` builds of `regression-31157`)
- Left [comment](https://github.com/rust-lang/rust/pull/88575#issuecomment-924402503) that didn't even bother to take time to be wishy-washy.

Use <[T; N]>::map in Sharded instead of SmallVec and unsafe code [#89069](https://github.com/rust-lang/rust/issues/89069)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=db1fb85cff63ad5fffe435e17128f99f9e1d970c&end=3bb9eecf07630be796c587a4bba70c49ae6a1bae&stat=instructions:u) (up to -0.3% on `incr-unchanged` builds of `ucd`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=db1fb85cff63ad5fffe435e17128f99f9e1d970c&end=3bb9eecf07630be796c587a4bba70c49ae6a1bae&stat=instructions:u) (up to 2.8% on `incr-full` builds of `ctfe-stress-4`)
- Left [comment](https://github.com/rust-lang/rust/pull/89069#issuecomment-924405935); the estimated effect looks pretty different from when the PR was filed vs when it landed, but either way it is probably noise.

Lower only one HIR owner at a time [#87234](https://github.com/rust-lang/rust/issues/87234)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=e7958d35ca2c898a223efe402481e0ecb854310a&end=49c0861ed0fa1d95186d88df0cd4310103e70957&stat=instructions:u) (up to -1.3% on `full` builds of `unused-warnings`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=e7958d35ca2c898a223efe402481e0ecb854310a&end=49c0861ed0fa1d95186d88df0cd4310103e70957&stat=instructions:u) (up to 0.4% on `incr-unchanged` builds of `helloworld`)
- [Triaged](https://github.com/rust-lang/rust/pull/87234#issuecomment-924407705)

#### Untriaged Pull Requests

- [#89125 Don't use projection cache or candidate cache in intercrate mode](https://github.com/rust-lang/rust/pull/89125)
- [#89031 Don't inline OnceCell initialization closures](https://github.com/rust-lang/rust/pull/89031)
- [#88945 Remove concept of 'completion' from the projection cache](https://github.com/rust-lang/rust/pull/88945)
- [#88881 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/88881)
- [#88824 Rollup of 15 pull requests](https://github.com/rust-lang/rust/pull/88824)
- [#88710 Use index newtyping for TyVid](https://github.com/rust-lang/rust/pull/88710)
- [#88703 Gather module items after lowering.](https://github.com/rust-lang/rust/pull/88703)
- [#88627 Do not preallocate HirIds](https://github.com/rust-lang/rust/pull/88627)
- [#88597 Move global analyses from lowering to resolution](https://github.com/rust-lang/rust/pull/88597)
- [#88575 Querify `FnAbi::of_{fn_ptr,instance}` as `fn_abi_of_{fn_ptr,instance}`.](https://github.com/rust-lang/rust/pull/88575)
- [#88552 Stop allocating vtable entries for non-object-safe methods](https://github.com/rust-lang/rust/pull/88552)
- [#88533 Concrete regions can show up in mir borrowck if the originated from there](https://github.com/rust-lang/rust/pull/88533)
- [#88530 Shrink Session a bit](https://github.com/rust-lang/rust/pull/88530)
- [#88435 Avoid invoking the hir_crate query to traverse the HIR](https://github.com/rust-lang/rust/pull/88435)
- [#88308 Morph `layout_raw` query into `layout_of`.](https://github.com/rust-lang/rust/pull/88308)
- [#87815 encode `generics_of` for fields and ty params](https://github.com/rust-lang/rust/pull/87815)
- [#87781 Remove box syntax from compiler and tools](https://github.com/rust-lang/rust/pull/87781)
- [#87688 Introduce `let...else`](https://github.com/rust-lang/rust/pull/87688)
- [#87234 Lower only one HIR owner at a time](https://github.com/rust-lang/rust/pull/87234)
- [#84373 Encode spans relative to the enclosing item](https://github.com/rust-lang/rust/pull/84373)
- [#83698 Use undef for uninitialized bytes in constants](https://github.com/rust-lang/rust/pull/83698)
- [#83302 Get piece unchecked in `write`](https://github.com/rust-lang/rust/pull/83302)
- [#82183 Simplify lazy DefPathHash decoding by using an on-disk hash table.](https://github.com/rust-lang/rust/pull/82183)
- [#80522 Split rustc_mir](https://github.com/rust-lang/rust/pull/80522)

