# 2024-01-08 Triage Log

Not a particularly notable week. Large swings aren't spurious but also are
driven by changes in high-level behavior (diagnostics going from zero to one
emission primarily), which causes a lot more work to happen. This isn't really
representative of the underlying rustc performance changing though.

Triage done by **@simulacrum**.
Revision range: [67b6975051b83ef2bd28f06e8467470d570aceb3..76101eecbe9aa80753664bbe637ad06d1925f315](https://perf.rust-lang.org/?start=67b6975051b83ef2bd28f06e8467470d570aceb3&end=76101eecbe9aa80753664bbe637ad06d1925f315&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 4.9%  | [0.2%, 24.3%]  | 14    |
| Regressions ❌ <br /> (secondary)  | 4.6%  | [0.2%, 29.9%]  | 55    |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.5%, -0.2%] | 61    |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.0%, -0.4%] | 14    |
| All ❌✅ (primary)                 | 0.5%  | [-1.5%, 24.3%] | 75    |


4 Regressions, 4 Improvements, 6 Mixed; 1 of them in rollups

33 artifact comparisons made in total

#### Regressions

rustc_lint: Enforce `rustc::potential_query_instability` lint [#119251](https://github.com/rust-lang/rust/pull/119251) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=67b6975051b83ef2bd28f06e8467470d570aceb3&end=e51e98dde6a60637b6a71b8105245b629ac3fe77&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2% | [0.2%, 0.3%] | 2     |
| Regressions ❌ <br /> (secondary)  | 0.3% | [0.2%, 0.4%] | 8     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.2% | [0.2%, 0.3%] | 2     |

Minor change in just a few benchmarks. Not clear whether this is noise or not
but the overall change is required for correctness.

Merge `unused_tuple_struct_fields` into `dead_code` [#118297](https://github.com/rust-lang/rust/pull/118297) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a59a98024e3fe317e37e218392f5c34e932b2394&end=5113ed28ea1451a13eae3a05dca0dbabfd56f587&stat=instructions:u)

| (instructions:u)                   | mean | range         | count |
|:----------------------------------:|:----:|:-------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6% | [0.3%, 0.8%]  | 7     |
| Regressions ❌ <br /> (secondary)  | 8.3% | [0.2%, 30.4%] | 28    |
| Improvements ✅ <br /> (primary)   | -    | -             | 0     |
| Improvements ✅ <br /> (secondary) | -    | -             | 0     |
| All ❌✅ (primary)                 | 0.6% | [0.3%, 0.8%]  | 7     |

Regressions are related to this lint firing in a few benchmarks, which causes a
good deal of lazy loading to actually happen in diagnostics infra.

Exhaustiveness: Statically enforce revealing of opaques [#119329](https://github.com/rust-lang/rust/pull/119329) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=595bc6f00369475047538fdae1ff8cea692ac385&end=5bcd86d89b2b7b6a490f7e075dd4eb346deb5f98&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -    | -            | 0     |
| Regressions ❌ <br /> (secondary)  | 1.9% | [1.7%, 2.0%] | 6     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | -    | -            | 0     |

Only a match-stress regression, seems like an acceptable change for the
correctness fix.

Inline a few utility functions around MIR [#119459](https://github.com/rust-lang/rust/pull/119459) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5bcd86d89b2b7b6a490f7e075dd4eb346deb5f98&end=d62f05b842d94d3bcad4d41d4b81df3949bad7c6&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.3%, 0.4%] | 3     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.3%, 0.4%] | 3     |

Potentially just noise. Overall impact is limited to just one benchmark and
only incr-full.

#### Improvements

Separate immediate and in-memory ScalarPair representation [#118991](https://github.com/rust-lang/rust/pull/118991) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6bc08a725f888a06ea3c6844f3d0cc2d2ebc5142&end=432fffa8afb8fcfe658e6548e5e8f10ad2001329&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.6%, 0.6%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.0% | [-1.5%, -0.6%] | 13    |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.2%] | 1     |
| All ❌✅ (primary)                 | -0.9% | [-1.5%, 0.6%]  | 14    |


rustc_span: Optimize syntax context comparisons [#119531](https://github.com/rust-lang/rust/pull/119531) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=efb3f1108750ab68c855bafd8caffe5d078b6f75&end=9212108a9b32cc381995cf509dd2627123c11a25&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-0.8%, -0.4%] | 5     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.6% | [-0.8%, -0.4%] | 5     |


Exhaustiveness: remove `Matrix.wildcard_row` [#119667](https://github.com/rust-lang/rust/pull/119667) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=87e1430893d55001034bd76c5dbe832d80bc50c3&end=d8b44d2802ab665b183dce06d527bf09175dd8cf&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -2.8% | [-3.0%, -2.6%] | 6     |
| All ❌✅ (primary)                 | -     | -              | 0     |


macro_rules: Add an expansion-local cache to span marker [#119693](https://github.com/rust-lang/rust/pull/119693) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=76101eecbe9aa80753664bbe637ad06d1925f315&end=0ee9cfd54db7b5f4be35f026588904500c866196&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -               | 0     |
| Improvements ✅ <br /> (primary)   | -1.4% | [-20.5%, -0.2%] | 80    |
| Improvements ✅ <br /> (secondary) | -0.8% | [-1.9%, -0.3%]  | 16    |
| All ❌✅ (primary)                 | -1.4% | [-20.5%, -0.2%] | 80    |

Largest improvements here are recovery from a spurious regression in previous
PR, but this is still a good win even aside from that.

#### Mixed

 Reorder check_item_type diagnostics so they occur next to the corresponding `check_well_formed` diagnostics [#117213](https://github.com/rust-lang/rust/pull/117213) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f688dd684faca5b31b156fac2c6e0ae81fc9bc90&end=791a53f380d5cf800191f25941c94ace5099876e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.4%]   | 7     |
| Regressions ❌ <br /> (secondary)  | 0.8%  | [0.2%, 2.3%]   | 5     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.3%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.1%  | [-0.3%, 0.4%]  | 9     |


Stabilize THIR unsafeck [#117673](https://github.com/rust-lang/rust/pull/117673) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8d39ec1825024f3014e1f847942ac5bbfcf055b0&end=6bc08a725f888a06ea3c6844f3d0cc2d2ebc5142&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.4%]   | 2     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.9%, -0.2%] | 39    |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.1%, -0.4%] | 9     |
| All ❌✅ (primary)                 | -0.4% | [-0.9%, -0.2%] | 39    |

Improvements outweigh regressions.

Replace a number of FxHashMaps/Sets with stable-iteration-order alternatives [#119192](https://github.com/rust-lang/rust/pull/119192) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=11035f9f52c65739d9613f5b9ecd332e9e640e71&end=b8c207435c85955d0c0806240d5491f5ccd1def5&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.1%, 0.5%]   | 7     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.6%, -0.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.4% | [-0.6%, -0.2%] | 2     |

Correctness fix, acceptable regressions.

Rollup of 9 pull requests [#119662](https://github.com/rust-lang/rust/pull/119662) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9212108a9b32cc381995cf509dd2627123c11a25&end=b6a8c762eed0ae0383658c38d65cb91bbd9800a1&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.7%  | [0.2%, 1.3%]   | 13    |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.2%] | 6     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.3% | [-0.4%, 0.2%]  | 7     |

tt-muncher is the primary significant regression, and appears to be
significantly beyond the noise level for that benchmark. Investigation is
ongoing.

mark vec::IntoIter pointers as `!nonnull` [#114205](https://github.com/rust-lang/rust/pull/114205) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6f4af9cbfc5ec176359c85446d1259a988299ea0&end=9522993b033e57579dcdee960d8792932aba791f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%  | [0.6%, 0.8%]   | 2     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.4%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.4%  | [-0.4%, 0.8%]  | 3     |

Likely slightly more work for LLVM.
