# Python package 'rviz' initialization.
#
# The actual implementations are defined in C++ and wrapped by
# shiboken or sip.  This wrapper finds which binding is available and
# presents it as package rviz.

import sys

# Can use the following setattr() call to force one binding or the other.
# setattr(sys, 'SELECT_QT_BINDING', 'pyside')

from python_qt_binding import QT_BINDING

if QT_BINDING == "pyside":

    # Import the shared library generated by the shiboken binding-generator.
    from . import librviz_shiboken as bindings

    # Expose the contained rviz class as bindings
    bindings = bindings.rviz

elif QT_BINDING == "pyqt":

    # Import the shared library generated by the sip binding-generator.
    from . import librviz_sip as bindings

    # Expose the contained rviz class as bindings
    bindings = bindings.rviz

else:
    raise ImportError('Qt binding name "%s" is unknown.' % QT_BINDING)
