//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/operationalinsights/armoperationalinsights"
	"net/http"
	"net/url"
	"regexp"
)

// DeletedWorkspacesServer is a fake server for instances of the armoperationalinsights.DeletedWorkspacesClient type.
type DeletedWorkspacesServer struct {
	// NewListPager is the fake for method DeletedWorkspacesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armoperationalinsights.DeletedWorkspacesClientListOptions) (resp azfake.PagerResponder[armoperationalinsights.DeletedWorkspacesClientListResponse])

	// NewListByResourceGroupPager is the fake for method DeletedWorkspacesClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armoperationalinsights.DeletedWorkspacesClientListByResourceGroupOptions) (resp azfake.PagerResponder[armoperationalinsights.DeletedWorkspacesClientListByResourceGroupResponse])
}

// NewDeletedWorkspacesServerTransport creates a new instance of DeletedWorkspacesServerTransport with the provided implementation.
// The returned DeletedWorkspacesServerTransport instance is connected to an instance of armoperationalinsights.DeletedWorkspacesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDeletedWorkspacesServerTransport(srv *DeletedWorkspacesServer) *DeletedWorkspacesServerTransport {
	return &DeletedWorkspacesServerTransport{
		srv:                         srv,
		newListPager:                newTracker[azfake.PagerResponder[armoperationalinsights.DeletedWorkspacesClientListResponse]](),
		newListByResourceGroupPager: newTracker[azfake.PagerResponder[armoperationalinsights.DeletedWorkspacesClientListByResourceGroupResponse]](),
	}
}

// DeletedWorkspacesServerTransport connects instances of armoperationalinsights.DeletedWorkspacesClient to instances of DeletedWorkspacesServer.
// Don't use this type directly, use NewDeletedWorkspacesServerTransport instead.
type DeletedWorkspacesServerTransport struct {
	srv                         *DeletedWorkspacesServer
	newListPager                *tracker[azfake.PagerResponder[armoperationalinsights.DeletedWorkspacesClientListResponse]]
	newListByResourceGroupPager *tracker[azfake.PagerResponder[armoperationalinsights.DeletedWorkspacesClientListByResourceGroupResponse]]
}

// Do implements the policy.Transporter interface for DeletedWorkspacesServerTransport.
func (d *DeletedWorkspacesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DeletedWorkspacesClient.NewListPager":
		resp, err = d.dispatchNewListPager(req)
	case "DeletedWorkspacesClient.NewListByResourceGroupPager":
		resp, err = d.dispatchNewListByResourceGroupPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DeletedWorkspacesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := d.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OperationalInsights/deletedWorkspaces`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := d.srv.NewListPager(nil)
		newListPager = &resp
		d.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		d.newListPager.remove(req)
	}
	return resp, nil
}

func (d *DeletedWorkspacesServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := d.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OperationalInsights/deletedWorkspaces`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		d.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		d.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}
