//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcdn

import "time"

// AFDDomain - Friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes, e.g.
// www.contoso.com.
type AFDDomain struct {
	// The JSON object that contains the properties of the domain to create.
	Properties *AFDDomainProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Read only system data
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// AFDDomainHTTPSParameters - The JSON object that contains the properties to secure a domain.
type AFDDomainHTTPSParameters struct {
	// REQUIRED; Defines the source of the SSL certificate.
	CertificateType *AfdCertificateType

	// TLS protocol version that will be used for Https
	MinimumTLSVersion *AfdMinimumTLSVersion

	// Resource reference to the secret. ie. subs/rg/profile/secret
	Secret *ResourceReference
}

// AFDDomainListResult - Result of the request to list domains. It contains a list of domain objects and a URL link to get
// the next set of results.
type AFDDomainListResult struct {
	// URL to get the next set of domain objects if there are any.
	NextLink *string

	// READ-ONLY; List of AzureFrontDoor domains within a profile.
	Value []*AFDDomain
}

// AFDDomainProperties - The JSON object that contains the properties of the domain to create.
type AFDDomainProperties struct {
	// REQUIRED; The host name of the domain. Must be a domain name.
	HostName *string

	// Resource reference to the Azure DNS zone
	AzureDNSZone *ResourceReference

	// Key-Value pair representing migration properties for domains.
	ExtendedProperties map[string]*string

	// Resource reference to the Azure resource where custom domain ownership was prevalidated
	PreValidatedCustomDomainResourceID *ResourceReference

	// The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed certificate or user's own
	// certificate. If not specified, enabling ssl uses AzureFrontDoor managed
	// certificate by default.
	TLSSettings *AFDDomainHTTPSParameters

	// READ-ONLY
	DeploymentStatus *DeploymentStatus

	// READ-ONLY; Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step. DCV stands
	// for DomainControlValidation.
	DomainValidationState *DomainValidationState

	// READ-ONLY; The name of the profile which holds the domain.
	ProfileName *string

	// READ-ONLY; Provisioning status
	ProvisioningState *AfdProvisioningState

	// READ-ONLY; Values the customer needs to validate domain ownership
	ValidationProperties *DomainValidationProperties
}

// AFDDomainUpdateParameters - The domain JSON object required for domain creation or update.
type AFDDomainUpdateParameters struct {
	// The JSON object that contains the properties of the domain to create.
	Properties *AFDDomainUpdatePropertiesParameters
}

// AFDDomainUpdatePropertiesParameters - The JSON object that contains the properties of the domain to create.
type AFDDomainUpdatePropertiesParameters struct {
	// Resource reference to the Azure DNS zone
	AzureDNSZone *ResourceReference

	// Resource reference to the Azure resource where custom domain ownership was prevalidated
	PreValidatedCustomDomainResourceID *ResourceReference

	// The configuration specifying how to enable HTTPS for the domain - using AzureFrontDoor managed certificate or user's own
	// certificate. If not specified, enabling ssl uses AzureFrontDoor managed
	// certificate by default.
	TLSSettings *AFDDomainHTTPSParameters

	// READ-ONLY; The name of the profile which holds the domain.
	ProfileName *string
}

// AFDEndpoint - Azure Front Door endpoint is the entity within a Azure Front Door profile containing configuration information
// such as origin, protocol, content caching and delivery behavior. The AzureFrontDoor
// endpoint uses the URL format .azureedge.net.
type AFDEndpoint struct {
	// REQUIRED; Resource location.
	Location *string

	// The JSON object that contains the properties required to create an endpoint.
	Properties *AFDEndpointProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Read only system data
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// AFDEndpointListResult - Result of the request to list endpoints. It contains a list of endpoint objects and a URL link
// to get the next set of results.
type AFDEndpointListResult struct {
	// URL to get the next set of endpoint objects if there is any.
	NextLink *string

	// READ-ONLY; List of AzureFrontDoor endpoints within a profile
	Value []*AFDEndpoint
}

// AFDEndpointProperties - The JSON object that contains the properties required to create an endpoint.
type AFDEndpointProperties struct {
	// Indicates the endpoint name reuse scope. The default value is TenantReuse.
	AutoGeneratedDomainNameLabelScope *AutoGeneratedDomainNameLabelScope

	// Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
	EnabledState *EnabledState

	// READ-ONLY
	DeploymentStatus *DeploymentStatus

	// READ-ONLY; The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g. contoso.azureedge.net
	HostName *string

	// READ-ONLY; The name of the profile which holds the endpoint.
	ProfileName *string

	// READ-ONLY; Provisioning status
	ProvisioningState *AfdProvisioningState
}

// AFDEndpointPropertiesUpdateParameters - The JSON object containing endpoint update parameters.
type AFDEndpointPropertiesUpdateParameters struct {
	// Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
	EnabledState *EnabledState

	// READ-ONLY; The name of the profile which holds the endpoint.
	ProfileName *string
}

// AFDEndpointUpdateParameters - Properties required to create or update an endpoint.
type AFDEndpointUpdateParameters struct {
	// The JSON object containing endpoint update parameters.
	Properties *AFDEndpointPropertiesUpdateParameters

	// Endpoint tags.
	Tags map[string]*string
}

// AFDOrigin - Azure Front Door origin is the source of the content being delivered via Azure Front Door. When the edge nodes
// represented by an endpoint do not have the requested content cached, they attempt to
// fetch it from one or more of the configured origins.
type AFDOrigin struct {
	// The JSON object that contains the properties of the origin.
	Properties *AFDOriginProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Read only system data
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// AFDOriginGroup - AFDOrigin group comprising of origins is used for load balancing to origins when the content cannot be
// served from Azure Front Door.
type AFDOriginGroup struct {
	// The JSON object that contains the properties of the origin group.
	Properties *AFDOriginGroupProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Read only system data
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// AFDOriginGroupListResult - Result of the request to list origin groups. It contains a list of origin groups objects and
// a URL link to get the next set of results.
type AFDOriginGroupListResult struct {
	// URL to get the next set of origin objects if there are any.
	NextLink *string

	// READ-ONLY; List of Azure Front Door origin groups within an Azure Front Door endpoint
	Value []*AFDOriginGroup
}

// AFDOriginGroupProperties - The JSON object that contains the properties of the origin group.
type AFDOriginGroupProperties struct {
	// Health probe settings to the origin that is used to determine the health of the origin.
	HealthProbeSettings *HealthProbeParameters

	// Load balancing settings for a backend pool
	LoadBalancingSettings *LoadBalancingSettingsParameters

	// Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
	SessionAffinityState *EnabledState

	// Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint
	// is added. Default is 10 mins. This property is currently not supported.
	TrafficRestorationTimeToHealedOrNewEndpointsInMinutes *int32

	// READ-ONLY
	DeploymentStatus *DeploymentStatus

	// READ-ONLY; The name of the profile which holds the origin group.
	ProfileName *string

	// READ-ONLY; Provisioning status
	ProvisioningState *AfdProvisioningState
}

// AFDOriginGroupUpdateParameters - AFDOrigin group properties needed for origin group creation or update.
type AFDOriginGroupUpdateParameters struct {
	// The JSON object that contains the properties of the origin group.
	Properties *AFDOriginGroupUpdatePropertiesParameters
}

// AFDOriginGroupUpdatePropertiesParameters - The JSON object that contains the properties of the origin group.
type AFDOriginGroupUpdatePropertiesParameters struct {
	// Health probe settings to the origin that is used to determine the health of the origin.
	HealthProbeSettings *HealthProbeParameters

	// Load balancing settings for a backend pool
	LoadBalancingSettings *LoadBalancingSettingsParameters

	// Whether to allow session affinity on this host. Valid options are 'Enabled' or 'Disabled'
	SessionAffinityState *EnabledState

	// Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint
	// is added. Default is 10 mins. This property is currently not supported.
	TrafficRestorationTimeToHealedOrNewEndpointsInMinutes *int32

	// READ-ONLY; The name of the profile which holds the origin group.
	ProfileName *string
}

// AFDOriginListResult - Result of the request to list origins. It contains a list of origin objects and a URL link to get
// the next set of results.
type AFDOriginListResult struct {
	// URL to get the next set of origin objects if there are any.
	NextLink *string

	// READ-ONLY; List of Azure Front Door origins within an Azure Front Door endpoint
	Value []*AFDOrigin
}

// AFDOriginProperties - The JSON object that contains the properties of the origin.
type AFDOriginProperties struct {
	// Resource reference to the Azure origin resource.
	AzureOrigin *ResourceReference

	// Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled
	// if there is a single enabled backend in single enabled backend pool.
	EnabledState *EnabledState

	// Whether to enable certificate name check at origin level
	EnforceCertificateNameCheck *bool

	// The value of the HTTP port. Must be between 1 and 65535.
	HTTPPort *int32

	// The value of the HTTPS port. Must be between 1 and 65535.
	HTTPSPort *int32

	// The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across
	// all origins in an endpoint.
	HostName *string

	// The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this
	// value. Azure Front Door origins, such as Web Apps, Blob Storage, and Cloud
	// Services require this host header value to match the origin hostname by default. This overrides the host header defined
	// at Endpoint
	OriginHostHeader *string

	// Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any
	// lower priority origin is healthy.Must be between 1 and 5
	Priority *int32

	// The properties of the private link resource for private origin.
	SharedPrivateLinkResource *SharedPrivateLinkResourceProperties

	// Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
	Weight *int32

	// READ-ONLY
	DeploymentStatus *DeploymentStatus

	// READ-ONLY; The name of the origin group which contains this origin.
	OriginGroupName *string

	// READ-ONLY; Provisioning status
	ProvisioningState *AfdProvisioningState
}

// AFDOriginUpdateParameters - AFDOrigin properties needed for origin update.
type AFDOriginUpdateParameters struct {
	// The JSON object that contains the properties of the origin.
	Properties *AFDOriginUpdatePropertiesParameters
}

// AFDOriginUpdatePropertiesParameters - The JSON object that contains the properties of the origin.
type AFDOriginUpdatePropertiesParameters struct {
	// Resource reference to the Azure origin resource.
	AzureOrigin *ResourceReference

	// Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled
	// if there is a single enabled backend in single enabled backend pool.
	EnabledState *EnabledState

	// Whether to enable certificate name check at origin level
	EnforceCertificateNameCheck *bool

	// The value of the HTTP port. Must be between 1 and 65535.
	HTTPPort *int32

	// The value of the HTTPS port. Must be between 1 and 65535.
	HTTPSPort *int32

	// The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across
	// all origins in an endpoint.
	HostName *string

	// The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this
	// value. Azure Front Door origins, such as Web Apps, Blob Storage, and Cloud
	// Services require this host header value to match the origin hostname by default. This overrides the host header defined
	// at Endpoint
	OriginHostHeader *string

	// Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any
	// lower priority origin is healthy.Must be between 1 and 5
	Priority *int32

	// The properties of the private link resource for private origin.
	SharedPrivateLinkResource *SharedPrivateLinkResourceProperties

	// Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
	Weight *int32

	// READ-ONLY; The name of the origin group which contains this origin.
	OriginGroupName *string
}

// ActivatedResourceReference - Reference to another resource along with its state.
type ActivatedResourceReference struct {
	// Resource ID.
	ID *string

	// READ-ONLY; Whether the resource is active or inactive
	IsActive *bool
}

// AfdPurgeParameters - Parameters required for content purge.
type AfdPurgeParameters struct {
	// REQUIRED; The path to the content to be purged. Can describe a file path or a wild card directory.
	ContentPaths []*string

	// List of domains.
	Domains []*string
}

// AfdRouteCacheConfiguration - Caching settings for a caching-type route. To disable caching, do not provide a cacheConfiguration
// object.
type AfdRouteCacheConfiguration struct {
	// compression settings.
	CompressionSettings *CompressionSettings

	// query parameters to include or exclude (comma separated).
	QueryParameters *string

	// Defines how Frontdoor caches requests that include query strings. You can ignore any query strings when caching, ignore
	// specific query strings, cache every request with a unique URL, or cache specific
	// query strings.
	QueryStringCachingBehavior *AfdQueryStringCachingBehavior
}

// AzureFirstPartyManagedCertificateParameters - Azure FirstParty Managed Certificate provided by other first party resource
// providers to enable HTTPS.
type AzureFirstPartyManagedCertificateParameters struct {
	// REQUIRED; The type of the secret resource.
	Type *SecretType

	// The list of SANs.
	SubjectAlternativeNames []*string

	// READ-ONLY; Certificate issuing authority.
	CertificateAuthority *string

	// READ-ONLY; Certificate expiration date.
	ExpirationDate *string

	// READ-ONLY; Resource reference to the Azure Key Vault certificate. Expected to be in format of
	// /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{certificateName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​
	SecretSource *ResourceReference

	// READ-ONLY; Subject name in the certificate.
	Subject *string

	// READ-ONLY; Certificate thumbprint.
	Thumbprint *string
}

// GetSecretParameters implements the SecretParametersClassification interface for type AzureFirstPartyManagedCertificateParameters.
func (a *AzureFirstPartyManagedCertificateParameters) GetSecretParameters() *SecretParameters {
	return &SecretParameters{
		Type: a.Type,
	}
}

// CacheConfiguration - Caching settings for a caching-type route. To disable caching, do not provide a cacheConfiguration
// object.
type CacheConfiguration struct {
	// Caching behavior for the requests
	CacheBehavior *RuleCacheBehavior

	// The duration for which the content needs to be cached. Allowed format is [d.]hh:mm:ss
	CacheDuration *string

	// Indicates whether content compression is enabled. If compression is enabled, content will be served as compressed if user
	// requests for a compressed version. Content won't be compressed on
	// AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
	IsCompressionEnabled *RuleIsCompressionEnabled

	// query parameters to include or exclude (comma separated).
	QueryParameters *string

	// Defines how Frontdoor caches requests that include query strings. You can ignore any query strings when caching, ignore
	// specific query strings, cache every request with a unique URL, or cache specific
	// query strings.
	QueryStringCachingBehavior *RuleQueryStringCachingBehavior
}

// CacheExpirationActionParameters - Defines the parameters for the cache expiration action.
type CacheExpirationActionParameters struct {
	// REQUIRED; Caching behavior for the requests
	CacheBehavior *CacheBehavior

	// REQUIRED; The level at which the content needs to be cached.
	CacheType *CacheType

	// REQUIRED
	TypeName *CacheExpirationActionParametersTypeName

	// The duration for which the content needs to be cached. Allowed format is [d.]hh:mm:ss
	CacheDuration *string
}

// CacheKeyQueryStringActionParameters - Defines the parameters for the cache-key query string action.
type CacheKeyQueryStringActionParameters struct {
	// REQUIRED; Caching behavior for the requests
	QueryStringBehavior *QueryStringBehavior

	// REQUIRED
	TypeName *CacheKeyQueryStringActionParametersTypeName

	// query parameters to include or exclude (comma separated).
	QueryParameters *string
}

// CanMigrateParameters - Request body for CanMigrate operation.
type CanMigrateParameters struct {
	// REQUIRED; Resource reference of the classic cdn profile or classic frontdoor that need to be migrated.
	ClassicResourceReference *ResourceReference
}

type CanMigrateProperties struct {
	Errors []*MigrationErrorType

	// READ-ONLY; Flag that says if the profile can be migrated
	CanMigrate *bool

	// READ-ONLY; Recommended sku for the migration
	DefaultSKU *CanMigrateDefaultSKU
}

// CanMigrateResult - Result for canMigrate operation.
type CanMigrateResult struct {
	Properties *CanMigrateProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource type.
	Type *string
}

// CertificateSourceParameters - Defines the parameters for using CDN managed certificate for securing custom domain.
type CertificateSourceParameters struct {
	// REQUIRED; Type of certificate used
	CertificateType *CertificateType

	// REQUIRED
	TypeName *CdnCertificateSourceParametersTypeName
}

// CheckEndpointNameAvailabilityInput - Input of CheckNameAvailability API.
type CheckEndpointNameAvailabilityInput struct {
	// REQUIRED; The resource name to validate.
	Name *string

	// REQUIRED; The type of the resource whose name is to be validated.
	Type *ResourceType

	// Indicates the endpoint name reuse scope. The default value is TenantReuse.
	AutoGeneratedDomainNameLabelScope *AutoGeneratedDomainNameLabelScope
}

// CheckEndpointNameAvailabilityOutput - Output of check name availability API.
type CheckEndpointNameAvailabilityOutput struct {
	// READ-ONLY; Returns the available hostname generated based on the AutoGeneratedDomainNameLabelScope when the name is available,
	// otherwise it returns empty string
	AvailableHostname *string

	// READ-ONLY; The detailed error message describing why the name is not available.
	Message *string

	// READ-ONLY; Indicates whether the name is available.
	NameAvailable *bool

	// READ-ONLY; The reason why the name is not available.
	Reason *string
}

// CheckHostNameAvailabilityInput - Input of CheckHostNameAvailability API.
type CheckHostNameAvailabilityInput struct {
	// REQUIRED; The host name to validate.
	HostName *string
}

// CheckNameAvailabilityInput - Input of CheckNameAvailability API.
type CheckNameAvailabilityInput struct {
	// REQUIRED; The resource name to validate.
	Name *string

	// REQUIRED; The type of the resource whose name is to be validated.
	Type *ResourceType
}

// CheckNameAvailabilityOutput - Output of check name availability API.
type CheckNameAvailabilityOutput struct {
	// READ-ONLY; The detailed error message describing why the name is not available.
	Message *string

	// READ-ONLY; Indicates whether the name is available.
	NameAvailable *bool

	// READ-ONLY; The reason why the name is not available.
	Reason *string
}

// CidrIPAddress - CIDR Ip address
type CidrIPAddress struct {
	// Ip address itself.
	BaseIPAddress *string

	// The length of the prefix of the ip address.
	PrefixLength *int32
}

// ClientPortMatchConditionParameters - Defines the parameters for ClientPort match conditions
type ClientPortMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *ClientPortOperator

	// REQUIRED
	TypeName *ClientPortMatchConditionParametersTypeName

	// The match value for the condition of the delivery rule
	MatchValues []*string

	// Describes if this is negate condition or not
	NegateCondition *bool

	// List of transforms
	Transforms []*Transform
}

type Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems struct {
	DateTime *time.Time
	Value    *float32
}

type Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems struct {
	DateTime *time.Time
	Value    *float32
}

type ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems struct {
	Metric     *string
	Percentage *float64
	Value      *int64
}

// CompressionSettings - settings for compression.
type CompressionSettings struct {
	// List of content types on which compression applies. The value should be a valid MIME type.
	ContentTypesToCompress []*string

	// Indicates whether content compression is enabled on AzureFrontDoor. Default value is false. If compression is enabled,
	// content will be served as compressed if user requests for a compressed version.
	// Content won't be compressed on AzureFrontDoor when requested content is smaller than 1 byte or larger than 1 MB.
	IsCompressionEnabled *bool
}

// ContinentsResponse - Continents Response
type ContinentsResponse struct {
	Continents       []*ContinentsResponseContinentsItem
	CountryOrRegions []*ContinentsResponseCountryOrRegionsItem
}

type ContinentsResponseContinentsItem struct {
	ID *string
}

type ContinentsResponseCountryOrRegionsItem struct {
	ContinentID *string
	ID          *string
}

// CookiesMatchConditionParameters - Defines the parameters for Cookies match conditions
type CookiesMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *CookiesOperator

	// REQUIRED
	TypeName *CookiesMatchConditionParametersTypeName

	// The match value for the condition of the delivery rule
	MatchValues []*string

	// Describes if this is negate condition or not
	NegateCondition *bool

	// Name of Cookies to be matched
	Selector *string

	// List of transforms
	Transforms []*Transform
}

// CustomDomain - Friendly domain name mapping to the endpoint hostname that the customer provides for branding purposes,
// e.g. www.contoso.com.
type CustomDomain struct {
	// The JSON object that contains the properties of the custom domain to create.
	Properties *CustomDomainProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Read only system data
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// CustomDomainHTTPSParameters - The JSON object that contains the properties to secure a custom domain.
type CustomDomainHTTPSParameters struct {
	// REQUIRED; Defines the source of the SSL certificate.
	CertificateSource *CertificateSource

	// REQUIRED; Defines the TLS extension protocol that is used for secure delivery.
	ProtocolType *ProtocolType

	// TLS protocol version that will be used for Https
	MinimumTLSVersion *MinimumTLSVersion
}

// GetCustomDomainHTTPSParameters implements the CustomDomainHTTPSParametersClassification interface for type CustomDomainHTTPSParameters.
func (c *CustomDomainHTTPSParameters) GetCustomDomainHTTPSParameters() *CustomDomainHTTPSParameters {
	return c
}

// CustomDomainListResult - Result of the request to list custom domains. It contains a list of custom domain objects and
// a URL link to get the next set of results.
type CustomDomainListResult struct {
	// URL to get the next set of custom domain objects if there are any.
	NextLink *string

	// READ-ONLY; List of CDN CustomDomains within an endpoint.
	Value []*CustomDomain
}

// CustomDomainParameters - The customDomain JSON object required for custom domain creation or update.
type CustomDomainParameters struct {
	// The JSON object that contains the properties of the custom domain to create.
	Properties *CustomDomainPropertiesParameters
}

// CustomDomainProperties - The JSON object that contains the properties of the custom domain to create.
type CustomDomainProperties struct {
	// REQUIRED; The host name of the custom domain. Must be a domain name.
	HostName *string

	// Certificate parameters for securing custom HTTPS
	CustomHTTPSParameters CustomDomainHTTPSParametersClassification

	// Special validation or data may be required when delivering CDN to some regions due to local compliance reasons. E.g. ICP
	// license number of a custom domain is required to deliver content in China.
	ValidationData *string

	// READ-ONLY; Provisioning status of the custom domain.
	CustomHTTPSProvisioningState *CustomHTTPSProvisioningState

	// READ-ONLY; Provisioning substate shows the progress of custom HTTPS enabling/disabling process step by step.
	CustomHTTPSProvisioningSubstate *CustomHTTPSProvisioningSubstate

	// READ-ONLY; Provisioning status of Custom Https of the custom domain.
	ProvisioningState *CustomHTTPSProvisioningState

	// READ-ONLY; Resource status of the custom domain.
	ResourceState *CustomDomainResourceState
}

// CustomDomainPropertiesParameters - The JSON object that contains the properties of the custom domain to create.
type CustomDomainPropertiesParameters struct {
	// REQUIRED; The host name of the custom domain. Must be a domain name.
	HostName *string
}

// CustomRule - Defines the common attributes for a custom rule that can be included in a waf policy
type CustomRule struct {
	// REQUIRED; Describes what action to be applied when rule matches
	Action *ActionType

	// REQUIRED; List of match conditions.
	MatchConditions []*MatchCondition

	// REQUIRED; Defines the name of the custom rule
	Name *string

	// REQUIRED; Defines in what order this rule be evaluated in the overall list of custom rules
	Priority *int32

	// Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
	EnabledState *CustomRuleEnabledState
}

// CustomRuleList - Defines contents of custom rules
type CustomRuleList struct {
	// List of rules
	Rules []*CustomRule
}

// CustomerCertificateParameters - Customer Certificate used for https
type CustomerCertificateParameters struct {
	// REQUIRED; Resource reference to the Azure Key Vault certificate. Expected to be in format of
	// /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{certificateName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​
	SecretSource *ResourceReference

	// REQUIRED; The type of the secret resource.
	Type *SecretType

	// Version of the secret to be used
	SecretVersion *string

	// The list of SANs.
	SubjectAlternativeNames []*string

	// Whether to use the latest version for the certificate
	UseLatestVersion *bool

	// READ-ONLY; Certificate issuing authority.
	CertificateAuthority *string

	// READ-ONLY; Certificate expiration date.
	ExpirationDate *string

	// READ-ONLY; Subject name in the certificate.
	Subject *string

	// READ-ONLY; Certificate thumbprint.
	Thumbprint *string
}

// GetSecretParameters implements the SecretParametersClassification interface for type CustomerCertificateParameters.
func (c *CustomerCertificateParameters) GetSecretParameters() *SecretParameters {
	return &SecretParameters{
		Type: c.Type,
	}
}

// DeepCreatedCustomDomain - Custom domains created on the CDN endpoint.
type DeepCreatedCustomDomain struct {
	// REQUIRED; Custom domain name.
	Name *string

	// Properties of the custom domain created on the CDN endpoint.
	Properties *DeepCreatedCustomDomainProperties
}

// DeepCreatedCustomDomainProperties - Properties of the custom domain created on the CDN endpoint.
type DeepCreatedCustomDomainProperties struct {
	// REQUIRED; The host name of the custom domain. Must be a domain name.
	HostName *string

	// Special validation or data may be required when delivering CDN to some regions due to local compliance reasons. E.g. ICP
	// license number of a custom domain is required to deliver content in China.
	ValidationData *string
}

// DeepCreatedOrigin - The main origin of CDN content which is added when creating a CDN endpoint.
type DeepCreatedOrigin struct {
	// REQUIRED; Origin name which must be unique within the endpoint.
	Name *string

	// Properties of the origin created on the CDN endpoint.
	Properties *DeepCreatedOriginProperties
}

// DeepCreatedOriginGroup - The origin group for CDN content which is added when creating a CDN endpoint. Traffic is sent
// to the origins within the origin group based on origin health.
type DeepCreatedOriginGroup struct {
	// REQUIRED; Origin group name which must be unique within the endpoint.
	Name *string

	// Properties of the origin group created on the CDN endpoint.
	Properties *DeepCreatedOriginGroupProperties
}

// DeepCreatedOriginGroupProperties - Properties of the origin group created on the CDN endpoint.
type DeepCreatedOriginGroupProperties struct {
	// REQUIRED; The source of the content being delivered via CDN within given origin group.
	Origins []*ResourceReference

	// Health probe settings to the origin that is used to determine the health of the origin.
	HealthProbeSettings *HealthProbeParameters

	// The JSON object that contains the properties to determine origin health using real requests/responses.This property is
	// currently not supported.
	ResponseBasedOriginErrorDetectionSettings *ResponseBasedOriginErrorDetectionParameters

	// Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint
	// is added. Default is 10 mins. This property is currently not supported.
	TrafficRestorationTimeToHealedOrNewEndpointsInMinutes *int32
}

// DeepCreatedOriginProperties - Properties of the origin created on the CDN endpoint.
type DeepCreatedOriginProperties struct {
	// REQUIRED; The address of the origin. It can be a domain name, IPv4 address, or IPv6 address. This should be unique across
	// all origins in an endpoint.
	HostName *string

	// Origin is enabled for load balancing or not. By default, origin is always enabled.
	Enabled *bool

	// The value of the HTTP port. Must be between 1 and 65535.
	HTTPPort *int32

	// The value of the HTTPS port. Must be between 1 and 65535.
	HTTPSPort *int32

	// The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this
	// value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services
	// require this host header value to match the origin hostname by default.
	OriginHostHeader *string

	// Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any
	// lower priority origin is healthy.Must be between 1 and 5.
	Priority *int32

	// The Alias of the Private Link resource. Populating this optional field indicates that this origin is 'Private'
	PrivateLinkAlias *string

	// A custom message to be included in the approval request to connect to the Private Link.
	PrivateLinkApprovalMessage *string

	// The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
	PrivateLinkLocation *string

	// The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
	PrivateLinkResourceID *string

	// Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
	Weight *int32

	// READ-ONLY; The approval status for the connection to the Private Link
	PrivateEndpointStatus *PrivateEndpointStatus
}

// DeliveryRule - A rule that specifies a set of actions and conditions
type DeliveryRule struct {
	// REQUIRED; A list of actions that are executed when all the conditions of a rule are satisfied.
	Actions []DeliveryRuleActionAutoGeneratedClassification

	// REQUIRED; The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser
	// order will be applied before a rule with a greater order. Rule with order 0 is a special
	// rule. It does not require any condition and actions listed in it will always be applied.
	Order *int32

	// A list of conditions that must be matched for the actions to be executed
	Conditions []DeliveryRuleConditionClassification

	// Name of the rule
	Name *string
}

// DeliveryRuleActionAutoGenerated - An action for the delivery rule.
type DeliveryRuleActionAutoGenerated struct {
	// REQUIRED; The name of the action for the delivery rule.
	Name *DeliveryRuleAction
}

// GetDeliveryRuleActionAutoGenerated implements the DeliveryRuleActionAutoGeneratedClassification interface for type DeliveryRuleActionAutoGenerated.
func (d *DeliveryRuleActionAutoGenerated) GetDeliveryRuleActionAutoGenerated() *DeliveryRuleActionAutoGenerated {
	return d
}

// DeliveryRuleCacheExpirationAction - Defines the cache expiration action for the delivery rule.
type DeliveryRuleCacheExpirationAction struct {
	// REQUIRED; The name of the action for the delivery rule.
	Name *DeliveryRuleAction

	// REQUIRED; Defines the parameters for the action.
	Parameters *CacheExpirationActionParameters
}

// GetDeliveryRuleActionAutoGenerated implements the DeliveryRuleActionAutoGeneratedClassification interface for type DeliveryRuleCacheExpirationAction.
func (d *DeliveryRuleCacheExpirationAction) GetDeliveryRuleActionAutoGenerated() *DeliveryRuleActionAutoGenerated {
	return &DeliveryRuleActionAutoGenerated{
		Name: d.Name,
	}
}

// DeliveryRuleCacheKeyQueryStringAction - Defines the cache-key query string action for the delivery rule.
type DeliveryRuleCacheKeyQueryStringAction struct {
	// REQUIRED; The name of the action for the delivery rule.
	Name *DeliveryRuleAction

	// REQUIRED; Defines the parameters for the action.
	Parameters *CacheKeyQueryStringActionParameters
}

// GetDeliveryRuleActionAutoGenerated implements the DeliveryRuleActionAutoGeneratedClassification interface for type DeliveryRuleCacheKeyQueryStringAction.
func (d *DeliveryRuleCacheKeyQueryStringAction) GetDeliveryRuleActionAutoGenerated() *DeliveryRuleActionAutoGenerated {
	return &DeliveryRuleActionAutoGenerated{
		Name: d.Name,
	}
}

// DeliveryRuleClientPortCondition - Defines the ClientPort condition for the delivery rule.
type DeliveryRuleClientPortCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable

	// REQUIRED; Defines the parameters for the condition.
	Parameters *ClientPortMatchConditionParameters
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleClientPortCondition.
func (d *DeliveryRuleClientPortCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleCondition - A condition for the delivery rule.
type DeliveryRuleCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleCondition.
func (d *DeliveryRuleCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition { return d }

// DeliveryRuleCookiesCondition - Defines the Cookies condition for the delivery rule.
type DeliveryRuleCookiesCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable

	// REQUIRED; Defines the parameters for the condition.
	Parameters *CookiesMatchConditionParameters
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleCookiesCondition.
func (d *DeliveryRuleCookiesCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleHTTPVersionCondition - Defines the HttpVersion condition for the delivery rule.
type DeliveryRuleHTTPVersionCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable

	// REQUIRED; Defines the parameters for the condition.
	Parameters *HTTPVersionMatchConditionParameters
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleHTTPVersionCondition.
func (d *DeliveryRuleHTTPVersionCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleHostNameCondition - Defines the HostName condition for the delivery rule.
type DeliveryRuleHostNameCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable

	// REQUIRED; Defines the parameters for the condition.
	Parameters *HostNameMatchConditionParameters
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleHostNameCondition.
func (d *DeliveryRuleHostNameCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleIsDeviceCondition - Defines the IsDevice condition for the delivery rule.
type DeliveryRuleIsDeviceCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable

	// REQUIRED; Defines the parameters for the condition.
	Parameters *IsDeviceMatchConditionParameters
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleIsDeviceCondition.
func (d *DeliveryRuleIsDeviceCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRulePostArgsCondition - Defines the PostArgs condition for the delivery rule.
type DeliveryRulePostArgsCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable

	// REQUIRED; Defines the parameters for the condition.
	Parameters *PostArgsMatchConditionParameters
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRulePostArgsCondition.
func (d *DeliveryRulePostArgsCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleQueryStringCondition - Defines the QueryString condition for the delivery rule.
type DeliveryRuleQueryStringCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable

	// REQUIRED; Defines the parameters for the condition.
	Parameters *QueryStringMatchConditionParameters
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleQueryStringCondition.
func (d *DeliveryRuleQueryStringCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleRemoteAddressCondition - Defines the RemoteAddress condition for the delivery rule.
type DeliveryRuleRemoteAddressCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable

	// REQUIRED; Defines the parameters for the condition.
	Parameters *RemoteAddressMatchConditionParameters
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleRemoteAddressCondition.
func (d *DeliveryRuleRemoteAddressCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleRequestBodyCondition - Defines the RequestBody condition for the delivery rule.
type DeliveryRuleRequestBodyCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable

	// REQUIRED; Defines the parameters for the condition.
	Parameters *RequestBodyMatchConditionParameters
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleRequestBodyCondition.
func (d *DeliveryRuleRequestBodyCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleRequestHeaderAction - Defines the request header action for the delivery rule.
type DeliveryRuleRequestHeaderAction struct {
	// REQUIRED; The name of the action for the delivery rule.
	Name *DeliveryRuleAction

	// REQUIRED; Defines the parameters for the action.
	Parameters *HeaderActionParameters
}

// GetDeliveryRuleActionAutoGenerated implements the DeliveryRuleActionAutoGeneratedClassification interface for type DeliveryRuleRequestHeaderAction.
func (d *DeliveryRuleRequestHeaderAction) GetDeliveryRuleActionAutoGenerated() *DeliveryRuleActionAutoGenerated {
	return &DeliveryRuleActionAutoGenerated{
		Name: d.Name,
	}
}

// DeliveryRuleRequestHeaderCondition - Defines the RequestHeader condition for the delivery rule.
type DeliveryRuleRequestHeaderCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable

	// REQUIRED; Defines the parameters for the condition.
	Parameters *RequestHeaderMatchConditionParameters
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleRequestHeaderCondition.
func (d *DeliveryRuleRequestHeaderCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleRequestMethodCondition - Defines the RequestMethod condition for the delivery rule.
type DeliveryRuleRequestMethodCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable

	// REQUIRED; Defines the parameters for the condition.
	Parameters *RequestMethodMatchConditionParameters
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleRequestMethodCondition.
func (d *DeliveryRuleRequestMethodCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleRequestSchemeCondition - Defines the RequestScheme condition for the delivery rule.
type DeliveryRuleRequestSchemeCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable

	// REQUIRED; Defines the parameters for the condition.
	Parameters *RequestSchemeMatchConditionParameters
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleRequestSchemeCondition.
func (d *DeliveryRuleRequestSchemeCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleRequestURICondition - Defines the RequestUri condition for the delivery rule.
type DeliveryRuleRequestURICondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable

	// REQUIRED; Defines the parameters for the condition.
	Parameters *RequestURIMatchConditionParameters
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleRequestURICondition.
func (d *DeliveryRuleRequestURICondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleResponseHeaderAction - Defines the response header action for the delivery rule.
type DeliveryRuleResponseHeaderAction struct {
	// REQUIRED; The name of the action for the delivery rule.
	Name *DeliveryRuleAction

	// REQUIRED; Defines the parameters for the action.
	Parameters *HeaderActionParameters
}

// GetDeliveryRuleActionAutoGenerated implements the DeliveryRuleActionAutoGeneratedClassification interface for type DeliveryRuleResponseHeaderAction.
func (d *DeliveryRuleResponseHeaderAction) GetDeliveryRuleActionAutoGenerated() *DeliveryRuleActionAutoGenerated {
	return &DeliveryRuleActionAutoGenerated{
		Name: d.Name,
	}
}

// DeliveryRuleRouteConfigurationOverrideAction - Defines the route configuration override action for the delivery rule. Only
// applicable to Frontdoor Standard/Premium Profiles.
type DeliveryRuleRouteConfigurationOverrideAction struct {
	// REQUIRED; The name of the action for the delivery rule.
	Name *DeliveryRuleAction

	// REQUIRED; Defines the parameters for the action.
	Parameters *RouteConfigurationOverrideActionParameters
}

// GetDeliveryRuleActionAutoGenerated implements the DeliveryRuleActionAutoGeneratedClassification interface for type DeliveryRuleRouteConfigurationOverrideAction.
func (d *DeliveryRuleRouteConfigurationOverrideAction) GetDeliveryRuleActionAutoGenerated() *DeliveryRuleActionAutoGenerated {
	return &DeliveryRuleActionAutoGenerated{
		Name: d.Name,
	}
}

// DeliveryRuleSSLProtocolCondition - Defines the SslProtocol condition for the delivery rule.
type DeliveryRuleSSLProtocolCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable

	// REQUIRED; Defines the parameters for the condition.
	Parameters *SSLProtocolMatchConditionParameters
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleSSLProtocolCondition.
func (d *DeliveryRuleSSLProtocolCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleServerPortCondition - Defines the ServerPort condition for the delivery rule.
type DeliveryRuleServerPortCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable

	// REQUIRED; Defines the parameters for the condition.
	Parameters *ServerPortMatchConditionParameters
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleServerPortCondition.
func (d *DeliveryRuleServerPortCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleSocketAddrCondition - Defines the SocketAddress condition for the delivery rule.
type DeliveryRuleSocketAddrCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable

	// REQUIRED; Defines the parameters for the condition.
	Parameters *SocketAddrMatchConditionParameters
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleSocketAddrCondition.
func (d *DeliveryRuleSocketAddrCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleURLFileExtensionCondition - Defines the UrlFileExtension condition for the delivery rule.
type DeliveryRuleURLFileExtensionCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable

	// REQUIRED; Defines the parameters for the condition.
	Parameters *URLFileExtensionMatchConditionParameters
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleURLFileExtensionCondition.
func (d *DeliveryRuleURLFileExtensionCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleURLFileNameCondition - Defines the UrlFileName condition for the delivery rule.
type DeliveryRuleURLFileNameCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable

	// REQUIRED; Defines the parameters for the condition.
	Parameters *URLFileNameMatchConditionParameters
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleURLFileNameCondition.
func (d *DeliveryRuleURLFileNameCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DeliveryRuleURLPathCondition - Defines the UrlPath condition for the delivery rule.
type DeliveryRuleURLPathCondition struct {
	// REQUIRED; The name of the condition for the delivery rule.
	Name *MatchVariable

	// REQUIRED; Defines the parameters for the condition.
	Parameters *URLPathMatchConditionParameters
}

// GetDeliveryRuleCondition implements the DeliveryRuleConditionClassification interface for type DeliveryRuleURLPathCondition.
func (d *DeliveryRuleURLPathCondition) GetDeliveryRuleCondition() *DeliveryRuleCondition {
	return &DeliveryRuleCondition{
		Name: d.Name,
	}
}

// DimensionProperties - Type of operation: get, read, delete, etc.
type DimensionProperties struct {
	// Display name of dimension.
	DisplayName *string

	// Internal name of dimension.
	InternalName *string

	// Name of dimension.
	Name *string
}

// DomainValidationProperties - The JSON object that contains the properties to validate a domain.
type DomainValidationProperties struct {
	// READ-ONLY; The date time that the token expires
	ExpirationDate *string

	// READ-ONLY; Challenge used for DNS TXT record or file based validation
	ValidationToken *string
}

// EdgeNode - Edgenode is a global Point of Presence (POP) location used to deliver CDN content to end users.
type EdgeNode struct {
	// The JSON object that contains the properties required to create an edgenode.
	Properties *EdgeNodeProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Read only system data
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// EdgeNodeProperties - The JSON object that contains the properties required to create an edgenode.
type EdgeNodeProperties struct {
	// REQUIRED; List of ip address groups.
	IPAddressGroups []*IPAddressGroup
}

// EdgenodeResult - Result of the request to list CDN edgenodes. It contains a list of ip address group and a URL link to
// get the next set of results.
type EdgenodeResult struct {
	// URL to get the next set of edgenode list results if there are any.
	NextLink *string

	// READ-ONLY; Edge node of CDN service.
	Value []*EdgeNode
}

// Endpoint - CDN endpoint is the entity within a CDN profile containing configuration information such as origin, protocol,
// content caching and delivery behavior. The CDN endpoint uses the URL format
// .azureedge.net.
type Endpoint struct {
	// REQUIRED; Resource location.
	Location *string

	// The JSON object that contains the properties required to create an endpoint.
	Properties *EndpointProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Read only system data
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// EndpointListResult - Result of the request to list endpoints. It contains a list of endpoint objects and a URL link to
// get the next set of results.
type EndpointListResult struct {
	// URL to get the next set of endpoint objects if there is any.
	NextLink *string

	// READ-ONLY; List of CDN endpoints within a profile
	Value []*Endpoint
}

// EndpointProperties - The JSON object that contains the properties required to create an endpoint.
type EndpointProperties struct {
	// REQUIRED; The source of the content being delivered via CDN.
	Origins []*DeepCreatedOrigin

	// List of content types on which compression applies. The value should be a valid MIME type.
	ContentTypesToCompress []*string

	// A reference to the origin group.
	DefaultOriginGroup *ResourceReference

	// A policy that specifies the delivery rules to be used for an endpoint.
	DeliveryPolicy *EndpointPropertiesUpdateParametersDeliveryPolicy

	// List of rules defining the user's geo access within a CDN endpoint. Each geo filter defines an access rule to a specified
	// path or content, e.g. block APAC for path /pictures/
	GeoFilters []*GeoFilter

	// Indicates whether content compression is enabled on CDN. Default value is false. If compression is enabled, content will
	// be served as compressed if user requests for a compressed version. Content
	// won't be compressed on CDN when requested content is smaller than 1 byte or larger than 1 MB.
	IsCompressionEnabled *bool

	// Indicates whether HTTP traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS)
	// must be allowed.
	IsHTTPAllowed *bool

	// Indicates whether HTTPS traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS)
	// must be allowed.
	IsHTTPSAllowed *bool

	// Specifies what scenario the customer wants this CDN endpoint to optimize for, e.g. Download, Media services. With this
	// information, CDN can apply scenario driven optimization.
	OptimizationType *OptimizationType

	// The origin groups comprising of origins that are used for load balancing the traffic based on availability.
	OriginGroups []*DeepCreatedOriginGroup

	// The host header value sent to the origin with each request. This property at Endpoint is only allowed when endpoint uses
	// single origin and can be overridden by the same property specified at origin.If
	// you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and
	// Cloud Services require this host header value to match the origin hostname by
	// default.
	OriginHostHeader *string

	// A directory path on the origin that CDN can use to retrieve content from, e.g. contoso.cloudapp.net/originpath.
	OriginPath *string

	// Path to a file hosted on the origin which helps accelerate delivery of the dynamic content and calculate the most optimal
	// routes for the CDN. This is relative to the origin path. This property is only
	// relevant when using a single origin.
	ProbePath *string

	// Defines how CDN caches requests that include query strings. You can ignore any query strings when caching, bypass caching
	// to prevent requests that contain query strings from being cached, or cache
	// every request with a unique URL.
	QueryStringCachingBehavior *QueryStringCachingBehavior

	// List of keys used to validate the signed URL hashes.
	URLSigningKeys []*URLSigningKey

	// Defines the Web Application Firewall policy for the endpoint (if applicable)
	WebApplicationFirewallPolicyLink *EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink

	// READ-ONLY; The custom domains under the endpoint.
	CustomDomains []*DeepCreatedCustomDomain

	// READ-ONLY; The host name of the endpoint structured as {endpointName}.{DNSZone}, e.g. contoso.azureedge.net
	HostName *string

	// READ-ONLY; Provisioning status of the endpoint.
	ProvisioningState *EndpointProvisioningState

	// READ-ONLY; Resource status of the endpoint.
	ResourceState *EndpointResourceState
}

// EndpointPropertiesUpdateParameters - The JSON object containing endpoint update parameters.
type EndpointPropertiesUpdateParameters struct {
	// List of content types on which compression applies. The value should be a valid MIME type.
	ContentTypesToCompress []*string

	// A reference to the origin group.
	DefaultOriginGroup *ResourceReference

	// A policy that specifies the delivery rules to be used for an endpoint.
	DeliveryPolicy *EndpointPropertiesUpdateParametersDeliveryPolicy

	// List of rules defining the user's geo access within a CDN endpoint. Each geo filter defines an access rule to a specified
	// path or content, e.g. block APAC for path /pictures/
	GeoFilters []*GeoFilter

	// Indicates whether content compression is enabled on CDN. Default value is false. If compression is enabled, content will
	// be served as compressed if user requests for a compressed version. Content
	// won't be compressed on CDN when requested content is smaller than 1 byte or larger than 1 MB.
	IsCompressionEnabled *bool

	// Indicates whether HTTP traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS)
	// must be allowed.
	IsHTTPAllowed *bool

	// Indicates whether HTTPS traffic is allowed on the endpoint. Default value is true. At least one protocol (HTTP or HTTPS)
	// must be allowed.
	IsHTTPSAllowed *bool

	// Specifies what scenario the customer wants this CDN endpoint to optimize for, e.g. Download, Media services. With this
	// information, CDN can apply scenario driven optimization.
	OptimizationType *OptimizationType

	// The host header value sent to the origin with each request. This property at Endpoint is only allowed when endpoint uses
	// single origin and can be overridden by the same property specified at origin.If
	// you leave this blank, the request hostname determines this value. Azure CDN origins, such as Web Apps, Blob Storage, and
	// Cloud Services require this host header value to match the origin hostname by
	// default.
	OriginHostHeader *string

	// A directory path on the origin that CDN can use to retrieve content from, e.g. contoso.cloudapp.net/originpath.
	OriginPath *string

	// Path to a file hosted on the origin which helps accelerate delivery of the dynamic content and calculate the most optimal
	// routes for the CDN. This is relative to the origin path. This property is only
	// relevant when using a single origin.
	ProbePath *string

	// Defines how CDN caches requests that include query strings. You can ignore any query strings when caching, bypass caching
	// to prevent requests that contain query strings from being cached, or cache
	// every request with a unique URL.
	QueryStringCachingBehavior *QueryStringCachingBehavior

	// List of keys used to validate the signed URL hashes.
	URLSigningKeys []*URLSigningKey

	// Defines the Web Application Firewall policy for the endpoint (if applicable)
	WebApplicationFirewallPolicyLink *EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink
}

// EndpointPropertiesUpdateParametersDeliveryPolicy - A policy that specifies the delivery rules to be used for an endpoint.
type EndpointPropertiesUpdateParametersDeliveryPolicy struct {
	// REQUIRED; A list of the delivery rules.
	Rules []*DeliveryRule

	// User-friendly description of the policy.
	Description *string
}

// EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink - Defines the Web Application Firewall policy for the
// endpoint (if applicable)
type EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink struct {
	// Resource ID.
	ID *string
}

// EndpointUpdateParameters - Properties required to create or update an endpoint.
type EndpointUpdateParameters struct {
	// The JSON object containing endpoint update parameters.
	Properties *EndpointPropertiesUpdateParameters

	// Endpoint tags.
	Tags map[string]*string
}

// GeoFilter - Rules defining user's geo access within a CDN endpoint.
type GeoFilter struct {
	// REQUIRED; Action of the geo filter, i.e. allow or block access.
	Action *GeoFilterActions

	// REQUIRED; Two letter country or region codes defining user country or region access in a geo filter, e.g. AU, MX, US.
	CountryCodes []*string

	// REQUIRED; Relative path applicable to geo filter. (e.g. '/mypictures', '/mypicture/kitty.jpg', and etc.)
	RelativePath *string
}

// HTTPErrorRangeParameters - The JSON object that represents the range for http status codes
type HTTPErrorRangeParameters struct {
	// The inclusive start of the http status code range.
	Begin *int32

	// The inclusive end of the http status code range.
	End *int32
}

// HTTPVersionMatchConditionParameters - Defines the parameters for HttpVersion match conditions
type HTTPVersionMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *HTTPVersionOperator

	// REQUIRED
	TypeName *HTTPVersionMatchConditionParametersTypeName

	// The match value for the condition of the delivery rule
	MatchValues []*string

	// Describes if this is negate condition or not
	NegateCondition *bool

	// List of transforms
	Transforms []*Transform
}

// HeaderActionParameters - Defines the parameters for the request header action.
type HeaderActionParameters struct {
	// REQUIRED; Action to perform
	HeaderAction *HeaderAction

	// REQUIRED; Name of the header to modify
	HeaderName *string

	// REQUIRED
	TypeName *HeaderActionParametersTypeName

	// Value for the specified action
	Value *string
}

// HealthProbeParameters - The JSON object that contains the properties to send health probes to origin.
type HealthProbeParameters struct {
	// The number of seconds between health probes.Default is 240sec.
	ProbeIntervalInSeconds *int32

	// The path relative to the origin that is used to determine the health of the origin.
	ProbePath *string

	// Protocol to use for health probe.
	ProbeProtocol *ProbeProtocol

	// The type of health probe request that is made.
	ProbeRequestType *HealthProbeRequestType
}

// HostNameMatchConditionParameters - Defines the parameters for HostName match conditions
type HostNameMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *HostNameOperator

	// REQUIRED
	TypeName *HostNameMatchConditionParametersTypeName

	// The match value for the condition of the delivery rule
	MatchValues []*string

	// Describes if this is negate condition or not
	NegateCondition *bool

	// List of transforms
	Transforms []*Transform
}

// IPAddressGroup - CDN Ip address group
type IPAddressGroup struct {
	// The delivery region of the ip address group
	DeliveryRegion *string

	// The list of ip v4 addresses.
	IPv4Addresses []*CidrIPAddress

	// The list of ip v6 addresses.
	IPv6Addresses []*CidrIPAddress
}

// IsDeviceMatchConditionParameters - Defines the parameters for IsDevice match conditions
type IsDeviceMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *IsDeviceOperator

	// REQUIRED
	TypeName *IsDeviceMatchConditionParametersTypeName

	// The match value for the condition of the delivery rule
	MatchValues []*IsDeviceMatchConditionParametersMatchValuesItem

	// Describes if this is negate condition or not
	NegateCondition *bool

	// List of transforms
	Transforms []*Transform
}

// KeyVaultCertificateSourceParameters - Describes the parameters for using a user's KeyVault certificate for securing custom
// domain.
type KeyVaultCertificateSourceParameters struct {
	// REQUIRED; Describes the action that shall be taken when the certificate is removed from Key Vault.
	DeleteRule *DeleteRule

	// REQUIRED; Resource group of the user's Key Vault containing the SSL certificate
	ResourceGroupName *string

	// REQUIRED; The name of Key Vault Secret (representing the full certificate PFX) in Key Vault.
	SecretName *string

	// REQUIRED; Subscription Id of the user's Key Vault containing the SSL certificate
	SubscriptionID *string

	// REQUIRED
	TypeName *KeyVaultCertificateSourceParametersTypeName

	// REQUIRED; Describes the action that shall be taken when the certificate is updated in Key Vault.
	UpdateRule *UpdateRule

	// REQUIRED; The name of the user's Key Vault containing the SSL certificate
	VaultName *string

	// The version(GUID) of Key Vault Secret in Key Vault.
	SecretVersion *string
}

// KeyVaultSigningKeyParameters - Describes the parameters for using a user's KeyVault for URL Signing Key.
type KeyVaultSigningKeyParameters struct {
	// REQUIRED; Resource group of the user's Key Vault containing the secret
	ResourceGroupName *string

	// REQUIRED; The name of secret in Key Vault.
	SecretName *string

	// REQUIRED; The version(GUID) of secret in Key Vault.
	SecretVersion *string

	// REQUIRED; Subscription Id of the user's Key Vault containing the secret
	SubscriptionID *string

	// REQUIRED
	TypeName *KeyVaultSigningKeyParametersTypeName

	// REQUIRED; The name of the user's Key Vault containing the secret
	VaultName *string
}

// LinkedEndpoint - Defines the ARM Resource ID for the linked endpoints
type LinkedEndpoint struct {
	// ARM Resource ID string.
	ID *string
}

// LoadBalancingSettingsParameters - Round-Robin load balancing settings for a backend pool
type LoadBalancingSettingsParameters struct {
	// The additional latency in milliseconds for probes to fall into the lowest latency bucket
	AdditionalLatencyInMilliseconds *int32

	// The number of samples to consider for load balancing decisions
	SampleSize *int32

	// The number of samples within the sample period that must succeed
	SuccessfulSamplesRequired *int32
}

// LoadParameters - Parameters required for content load.
type LoadParameters struct {
	// REQUIRED; The path to the content to be loaded. Path should be a relative file URL of the origin.
	ContentPaths []*string
}

// LogSpecification - Log specification of operation.
type LogSpecification struct {
	// Blob duration of specification.
	BlobDuration *string

	// Display name of log specification.
	DisplayName *string

	// Pattern to filter based on name
	LogFilterPattern *string

	// Name of log specification.
	Name *string
}

// ManagedCertificateParameters - Managed Certificate used for https
type ManagedCertificateParameters struct {
	// REQUIRED; The type of the secret resource.
	Type *SecretType

	// READ-ONLY; Certificate expiration date.
	ExpirationDate *string

	// READ-ONLY; Subject name in the certificate.
	Subject *string
}

// GetSecretParameters implements the SecretParametersClassification interface for type ManagedCertificateParameters.
func (m *ManagedCertificateParameters) GetSecretParameters() *SecretParameters {
	return &SecretParameters{
		Type: m.Type,
	}
}

// ManagedHTTPSParameters - Defines the certificate source parameters using CDN managed certificate for enabling SSL.
type ManagedHTTPSParameters struct {
	// REQUIRED; Defines the source of the SSL certificate.
	CertificateSource *CertificateSource

	// REQUIRED; Defines the certificate source parameters using CDN managed certificate for enabling SSL.
	CertificateSourceParameters *CertificateSourceParameters

	// REQUIRED; Defines the TLS extension protocol that is used for secure delivery.
	ProtocolType *ProtocolType

	// TLS protocol version that will be used for Https
	MinimumTLSVersion *MinimumTLSVersion
}

// GetCustomDomainHTTPSParameters implements the CustomDomainHTTPSParametersClassification interface for type ManagedHTTPSParameters.
func (m *ManagedHTTPSParameters) GetCustomDomainHTTPSParameters() *CustomDomainHTTPSParameters {
	return &CustomDomainHTTPSParameters{
		CertificateSource: m.CertificateSource,
		MinimumTLSVersion: m.MinimumTLSVersion,
		ProtocolType:      m.ProtocolType,
	}
}

// ManagedRuleDefinition - Describes a managed rule definition.
type ManagedRuleDefinition struct {
	// READ-ONLY; Describes the functionality of the managed rule.
	Description *string

	// READ-ONLY; Identifier for the managed rule.
	RuleID *string
}

// ManagedRuleGroupDefinition - Describes a managed rule group.
type ManagedRuleGroupDefinition struct {
	// READ-ONLY; Description of the managed rule group.
	Description *string

	// READ-ONLY; Name of the managed rule group.
	RuleGroupName *string

	// READ-ONLY; List of rules within the managed rule group.
	Rules []*ManagedRuleDefinition
}

// ManagedRuleGroupOverride - Defines a managed rule group override setting.
type ManagedRuleGroupOverride struct {
	// REQUIRED; Describes the managed rule group within the rule set to override
	RuleGroupName *string

	// List of rules that will be enabled. If none specified, all rules in the group will be disabled.
	Rules []*ManagedRuleOverride
}

// ManagedRuleOverride - Defines a managed rule group override setting.
type ManagedRuleOverride struct {
	// REQUIRED; Identifier for the managed rule.
	RuleID *string

	// Describes the override action to be applied when rule matches.
	Action *ActionType

	// Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not specified.
	EnabledState *ManagedRuleEnabledState
}

// ManagedRuleSet - Defines a managed rule set.
type ManagedRuleSet struct {
	// REQUIRED; Defines the rule set type to use.
	RuleSetType *string

	// REQUIRED; Defines the version of the rule set to use.
	RuleSetVersion *string

	// Verizon only : If the rule set supports anomaly detection mode, this describes the threshold for blocking requests.
	AnomalyScore *int32

	// Defines the rule overrides to apply to the rule set.
	RuleGroupOverrides []*ManagedRuleGroupOverride
}

// ManagedRuleSetDefinition - Describes a managed rule set definition.
type ManagedRuleSetDefinition struct {
	// Describes managed rule set definition properties.
	Properties *ManagedRuleSetDefinitionProperties

	// The pricing tier (defines a CDN provider, feature list and rate) of the CdnWebApplicationFirewallPolicy.
	SKU *SKU

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Read only system data
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// ManagedRuleSetDefinitionList - List of managed rule set definitions available for use in a policy.
type ManagedRuleSetDefinitionList struct {
	// URL to retrieve next set of managed rule set definitions.
	NextLink *string

	// READ-ONLY; List of managed rule set definitions.
	Value []*ManagedRuleSetDefinition
}

// ManagedRuleSetDefinitionProperties - Properties for a managed rule set definition.
type ManagedRuleSetDefinitionProperties struct {
	// READ-ONLY; Provisioning state of the managed rule set.
	ProvisioningState *string

	// READ-ONLY; Rule groups of the managed rule set.
	RuleGroups []*ManagedRuleGroupDefinition

	// READ-ONLY; Type of the managed rule set.
	RuleSetType *string

	// READ-ONLY; Version of the managed rule set type.
	RuleSetVersion *string
}

// ManagedRuleSetList - Defines the list of managed rule sets for the policy.
type ManagedRuleSetList struct {
	// List of rule sets.
	ManagedRuleSets []*ManagedRuleSet
}

// ManagedServiceIdentity - Managed service identity (system assigned and/or user assigned identities)
type ManagedServiceIdentity struct {
	// REQUIRED; Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
	Type *ManagedServiceIdentityType

	// The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM
	// resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
	// The dictionary values can be empty objects ({}) in
	// requests.
	UserAssignedIdentities map[string]*UserAssignedIdentity

	// READ-ONLY; The service principal ID of the system assigned identity. This property will only be provided for a system assigned
	// identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *string
}

// MatchCondition - Define match conditions
type MatchCondition struct {
	// REQUIRED; List of possible match values.
	MatchValue []*string

	// REQUIRED; Match variable to compare against.
	MatchVariable *WafMatchVariable

	// REQUIRED; Describes operator to be matched
	Operator *Operator

	// Describes if the result of this condition should be negated.
	NegateCondition *bool

	// Selector can used to match a specific key for QueryString, Cookies, RequestHeader or PostArgs.
	Selector *string

	// List of transforms.
	Transforms []*TransformType
}

// MetricAvailability - Retention policy of a resource metric.
type MetricAvailability struct {
	BlobDuration *string
	TimeGrain    *string
}

// MetricSpecification - Metric specification of operation.
type MetricSpecification struct {
	// The metric aggregation type. Possible values include: 'Average', 'Count', 'Total'.
	AggregationType *string

	// Retention policies of a resource metric.
	Availabilities []*MetricAvailability

	// The dimensions of metric
	Dimensions []*DimensionProperties

	// Display description of metric specification.
	DisplayDescription *string

	// Display name of metric specification.
	DisplayName *string

	// Property to specify whether to fill gap with zero.
	FillGapWithZero *bool

	// Property to specify metric is internal or not.
	IsInternal *bool

	// Pattern to filter based on name
	MetricFilterPattern *string

	// Name of metric specification.
	Name *string

	// The supported time grain types for the metrics.
	SupportedTimeGrainTypes []*string

	// The metric unit. Possible values include: 'Bytes', 'Count', 'Milliseconds'.
	Unit *string
}

// MetricsResponse - Metrics Response
type MetricsResponse struct {
	DateTimeBegin *time.Time
	DateTimeEnd   *time.Time
	Granularity   *MetricsGranularity
	Series        []*MetricsResponseSeriesItem
}

type MetricsResponseSeriesItem struct {
	Data   []*Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems
	Groups []*MetricsResponseSeriesPropertiesItemsItem
	Metric *string
	Unit   *MetricsSeriesUnit
}

type MetricsResponseSeriesPropertiesItemsItem struct {
	Name  *string
	Value *string
}

// MigrateResult - Result for migrate operation.
type MigrateResult struct {
	Properties *MigrateResultProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource type.
	Type *string
}

type MigrateResultProperties struct {
	// READ-ONLY; Arm resource id of the migrated profile
	MigratedProfileResourceID *ResourceReference
}

// MigrationErrorType - Error response indicates CDN service is not able to process the incoming request. The reason is provided
// in the error message.
type MigrationErrorType struct {
	// READ-ONLY; Error code.
	Code *string

	// READ-ONLY; Error message indicating why the operation failed.
	ErrorMessage *string

	// READ-ONLY; Describes what needs to be done to fix the problem
	NextSteps *string

	// READ-ONLY; Resource which has the problem.
	ResourceName *string
}

// MigrationParameters - Request body for Migrate operation.
type MigrationParameters struct {
	// REQUIRED; Resource reference of the classic cdn profile or classic frontdoor that need to be migrated.
	ClassicResourceReference *ResourceReference

	// REQUIRED; Name of the new profile that need to be created.
	ProfileName *string

	// REQUIRED; Sku for the migration
	SKU *SKU

	// Waf mapping for the migrated profile
	MigrationWebApplicationFirewallMappings []*MigrationWebApplicationFirewallMapping
}

// MigrationWebApplicationFirewallMapping - Web Application Firewall Mapping
type MigrationWebApplicationFirewallMapping struct {
	// Migration From Waf policy
	MigratedFrom *ResourceReference

	// Migration to Waf policy
	MigratedTo *ResourceReference
}

// Operation - CDN REST API operation
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay

	// Indicates whether the operation is a data action
	IsDataAction *bool

	// Properties of operation, include metric specifications.
	OperationProperties *OperationProperties

	// READ-ONLY; Operation name: {provider}/{resource}/{operation}
	Name *string

	// READ-ONLY; The origin of operations.
	Origin *string
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// READ-ONLY; Description of operation.
	Description *string

	// READ-ONLY; Operation type: Read, write, delete, etc.
	Operation *string

	// READ-ONLY; Service provider: Microsoft.Cdn
	Provider *string

	// READ-ONLY; Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string
}

// OperationProperties - Properties of operation, include metric specifications.
type OperationProperties struct {
	// One property of operation, include metric specifications.
	ServiceSpecification *ServiceSpecification
}

// OperationsListResult - Result of the request to list CDN operations. It contains a list of operations and a URL link to
// get the next set of results.
type OperationsListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string

	// List of CDN operations supported by the CDN resource provider.
	Value []*Operation
}

// Origin - CDN origin is the source of the content being delivered via CDN. When the edge nodes represented by an endpoint
// do not have the requested content cached, they attempt to fetch it from one or more of
// the configured origins.
type Origin struct {
	// The JSON object that contains the properties of the origin.
	Properties *OriginProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Read only system data
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// OriginGroup - Origin group comprising of origins is used for load balancing to origins when the content cannot be served
// from CDN.
type OriginGroup struct {
	// The JSON object that contains the properties of the origin group.
	Properties *OriginGroupProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Read only system data
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// OriginGroupListResult - Result of the request to list origin groups. It contains a list of origin groups objects and a
// URL link to get the next set of results.
type OriginGroupListResult struct {
	// URL to get the next set of origin objects if there are any.
	NextLink *string

	// READ-ONLY; List of CDN origin groups within an endpoint
	Value []*OriginGroup
}

// OriginGroupOverride - Defines the parameters for the origin group override configuration.
type OriginGroupOverride struct {
	// Protocol this rule will use when forwarding traffic to backends.
	ForwardingProtocol *ForwardingProtocol

	// defines the OriginGroup that would override the DefaultOriginGroup on route.
	OriginGroup *ResourceReference
}

// OriginGroupOverrideAction - Defines the origin group override action for the delivery rule.
type OriginGroupOverrideAction struct {
	// REQUIRED; The name of the action for the delivery rule.
	Name *DeliveryRuleAction

	// REQUIRED; Defines the parameters for the action.
	Parameters *OriginGroupOverrideActionParameters
}

// GetDeliveryRuleActionAutoGenerated implements the DeliveryRuleActionAutoGeneratedClassification interface for type OriginGroupOverrideAction.
func (o *OriginGroupOverrideAction) GetDeliveryRuleActionAutoGenerated() *DeliveryRuleActionAutoGenerated {
	return &DeliveryRuleActionAutoGenerated{
		Name: o.Name,
	}
}

// OriginGroupOverrideActionParameters - Defines the parameters for the origin group override action.
type OriginGroupOverrideActionParameters struct {
	// REQUIRED; defines the OriginGroup that would override the DefaultOriginGroup.
	OriginGroup *ResourceReference

	// REQUIRED
	TypeName *OriginGroupOverrideActionParametersTypeName
}

// OriginGroupProperties - The JSON object that contains the properties of the origin group.
type OriginGroupProperties struct {
	// Health probe settings to the origin that is used to determine the health of the origin.
	HealthProbeSettings *HealthProbeParameters

	// The source of the content being delivered via CDN within given origin group.
	Origins []*ResourceReference

	// The JSON object that contains the properties to determine origin health using real requests/responses. This property is
	// currently not supported.
	ResponseBasedOriginErrorDetectionSettings *ResponseBasedOriginErrorDetectionParameters

	// Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint
	// is added. Default is 10 mins. This property is currently not supported.
	TrafficRestorationTimeToHealedOrNewEndpointsInMinutes *int32

	// READ-ONLY; Provisioning status of the origin group.
	ProvisioningState *OriginGroupProvisioningState

	// READ-ONLY; Resource status of the origin group.
	ResourceState *OriginGroupResourceState
}

// OriginGroupUpdateParameters - Origin group properties needed for origin group creation or update.
type OriginGroupUpdateParameters struct {
	// The JSON object that contains the properties of the origin group.
	Properties *OriginGroupUpdatePropertiesParameters
}

// OriginGroupUpdatePropertiesParameters - The JSON object that contains the properties of the origin group.
type OriginGroupUpdatePropertiesParameters struct {
	// Health probe settings to the origin that is used to determine the health of the origin.
	HealthProbeSettings *HealthProbeParameters

	// The source of the content being delivered via CDN within given origin group.
	Origins []*ResourceReference

	// The JSON object that contains the properties to determine origin health using real requests/responses. This property is
	// currently not supported.
	ResponseBasedOriginErrorDetectionSettings *ResponseBasedOriginErrorDetectionParameters

	// Time in minutes to shift the traffic to the endpoint gradually when an unhealthy endpoint comes healthy or a new endpoint
	// is added. Default is 10 mins. This property is currently not supported.
	TrafficRestorationTimeToHealedOrNewEndpointsInMinutes *int32
}

// OriginListResult - Result of the request to list origins. It contains a list of origin objects and a URL link to get the
// next set of results.
type OriginListResult struct {
	// URL to get the next set of origin objects if there are any.
	NextLink *string

	// READ-ONLY; List of CDN origins within an endpoint
	Value []*Origin
}

// OriginProperties - The JSON object that contains the properties of the origin.
type OriginProperties struct {
	// Origin is enabled for load balancing or not
	Enabled *bool

	// The value of the HTTP port. Must be between 1 and 65535.
	HTTPPort *int32

	// The value of the HTTPS port. Must be between 1 and 65535.
	HTTPSPort *int32

	// The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across
	// all origins in an endpoint.
	HostName *string

	// The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this
	// value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services
	// require this host header value to match the origin hostname by default. This overrides the host header defined at Endpoint
	OriginHostHeader *string

	// Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any
	// lower priority origin is healthy.Must be between 1 and 5
	Priority *int32

	// The Alias of the Private Link resource. Populating this optional field indicates that this origin is 'Private'
	PrivateLinkAlias *string

	// A custom message to be included in the approval request to connect to the Private Link.
	PrivateLinkApprovalMessage *string

	// The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
	PrivateLinkLocation *string

	// The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
	PrivateLinkResourceID *string

	// Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
	Weight *int32

	// READ-ONLY; The approval status for the connection to the Private Link
	PrivateEndpointStatus *PrivateEndpointStatus

	// READ-ONLY; Provisioning status of the origin.
	ProvisioningState *OriginProvisioningState

	// READ-ONLY; Resource status of the origin.
	ResourceState *OriginResourceState
}

// OriginUpdateParameters - Origin properties needed for origin update.
type OriginUpdateParameters struct {
	// The JSON object that contains the properties of the origin.
	Properties *OriginUpdatePropertiesParameters
}

// OriginUpdatePropertiesParameters - The JSON object that contains the properties of the origin.
type OriginUpdatePropertiesParameters struct {
	// Origin is enabled for load balancing or not
	Enabled *bool

	// The value of the HTTP port. Must be between 1 and 65535.
	HTTPPort *int32

	// The value of the HTTPS port. Must be between 1 and 65535.
	HTTPSPort *int32

	// The address of the origin. Domain names, IPv4 addresses, and IPv6 addresses are supported.This should be unique across
	// all origins in an endpoint.
	HostName *string

	// The host header value sent to the origin with each request. If you leave this blank, the request hostname determines this
	// value. Azure CDN origins, such as Web Apps, Blob Storage, and Cloud Services
	// require this host header value to match the origin hostname by default. This overrides the host header defined at Endpoint
	OriginHostHeader *string

	// Priority of origin in given origin group for load balancing. Higher priorities will not be used for load balancing if any
	// lower priority origin is healthy.Must be between 1 and 5
	Priority *int32

	// The Alias of the Private Link resource. Populating this optional field indicates that this origin is 'Private'
	PrivateLinkAlias *string

	// A custom message to be included in the approval request to connect to the Private Link.
	PrivateLinkApprovalMessage *string

	// The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
	PrivateLinkLocation *string

	// The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
	PrivateLinkResourceID *string

	// Weight of the origin in given origin group for load balancing. Must be between 1 and 1000
	Weight *int32
}

// PolicySettings - Defines contents of a web application firewall global configuration
type PolicySettings struct {
	// If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
	DefaultCustomBlockResponseBody *string

	// If the action type is block, this field defines the default customer overridable http response status code.
	DefaultCustomBlockResponseStatusCode *PolicySettingsDefaultCustomBlockResponseStatusCode

	// If action type is redirect, this field represents the default redirect URL for the client.
	DefaultRedirectURL *string

	// describes if the policy is in enabled state or disabled state
	EnabledState *PolicyEnabledState

	// Describes if it is in detection mode or prevention mode at policy level.
	Mode *PolicyMode
}

// PostArgsMatchConditionParameters - Defines the parameters for PostArgs match conditions
type PostArgsMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *PostArgsOperator

	// REQUIRED
	TypeName *PostArgsMatchConditionParametersTypeName

	// The match value for the condition of the delivery rule
	MatchValues []*string

	// Describes if this is negate condition or not
	NegateCondition *bool

	// Name of PostArg to be matched
	Selector *string

	// List of transforms
	Transforms []*Transform
}

// Profile - A profile is a logical grouping of endpoints that share the same settings.
type Profile struct {
	// REQUIRED; Resource location.
	Location *string

	// REQUIRED; The pricing tier (defines Azure Front Door Standard or Premium or a CDN provider, feature list and rate) of the
	// profile.
	SKU *SKU

	// Managed service identity (system assigned and/or user assigned identities).
	Identity *ManagedServiceIdentity

	// The JSON object that contains the properties required to create a profile.
	Properties *ProfileProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Kind of the profile. Used by portal to differentiate traditional CDN profile and new AFD profile.
	Kind *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Read only system data
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// ProfileChangeSKUWafMapping - Parameters required for profile upgrade.
type ProfileChangeSKUWafMapping struct {
	// REQUIRED; The new waf resource for the security policy to use.
	ChangeToWafPolicy *ResourceReference

	// REQUIRED; The security policy name.
	SecurityPolicyName *string
}

// ProfileListResult - Result of the request to list profiles. It contains a list of profile objects and a URL link to get
// the next set of results.
type ProfileListResult struct {
	// URL to get the next set of profile objects if there are any.
	NextLink *string

	// READ-ONLY; List of CDN profiles within a resource group.
	Value []*Profile
}

// ProfileProperties - The JSON object that contains the properties required to create a profile.
type ProfileProperties struct {
	// Send and receive timeout on forwarding request to the origin. When timeout is reached, the request fails and returns.
	OriginResponseTimeoutSeconds *int32

	// READ-ONLY; Key-Value pair representing additional properties for profiles.
	ExtendedProperties map[string]*string

	// READ-ONLY; The Id of the frontdoor.
	FrontDoorID *string

	// READ-ONLY; Provisioning status of the profile.
	ProvisioningState *ProfileProvisioningState

	// READ-ONLY; Resource status of the profile.
	ResourceState *ProfileResourceState
}

// ProfilePropertiesUpdateParameters - The JSON object containing profile update parameters.
type ProfilePropertiesUpdateParameters struct {
	// Send and receive timeout on forwarding request to the origin. When timeout is reached, the request fails and returns.
	OriginResponseTimeoutSeconds *int32
}

// ProfileUpdateParameters - Properties required to update a profile.
type ProfileUpdateParameters struct {
	// Managed service identity (system assigned and/or user assigned identities).
	Identity *ManagedServiceIdentity

	// The JSON object containing profile update parameters.
	Properties *ProfilePropertiesUpdateParameters

	// Profile tags
	Tags map[string]*string
}

// ProfileUpgradeParameters - Parameters required for profile upgrade.
type ProfileUpgradeParameters struct {
	// REQUIRED; Web Application Firewall (WAF) and security policy mapping for the profile upgrade
	WafMappingList []*ProfileChangeSKUWafMapping
}

// PurgeParameters - Parameters required for content purge.
type PurgeParameters struct {
	// REQUIRED; The path to the content to be purged. Can describe a file path or a wild card directory.
	ContentPaths []*string
}

// QueryStringMatchConditionParameters - Defines the parameters for QueryString match conditions
type QueryStringMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *QueryStringOperator

	// REQUIRED
	TypeName *QueryStringMatchConditionParametersTypeName

	// The match value for the condition of the delivery rule
	MatchValues []*string

	// Describes if this is negate condition or not
	NegateCondition *bool

	// List of transforms
	Transforms []*Transform
}

// RankingsResponse - Rankings Response
type RankingsResponse struct {
	DateTimeBegin *time.Time
	DateTimeEnd   *time.Time
	Tables        []*RankingsResponseTablesItem
}

type RankingsResponseTablesItem struct {
	Data    []*RankingsResponseTablesPropertiesItemsItem
	Ranking *string
}

type RankingsResponseTablesPropertiesItemsItem struct {
	Metrics []*RankingsResponseTablesPropertiesItemsMetricsItem
	Name    *string
}

type RankingsResponseTablesPropertiesItemsMetricsItem struct {
	Metric     *string
	Percentage *float32
	Value      *int64
}

// RateLimitRule - Defines a rate limiting rule that can be included in a waf policy
type RateLimitRule struct {
	// REQUIRED; Describes what action to be applied when rule matches
	Action *ActionType

	// REQUIRED; List of match conditions.
	MatchConditions []*MatchCondition

	// REQUIRED; Defines the name of the custom rule
	Name *string

	// REQUIRED; Defines in what order this rule be evaluated in the overall list of custom rules
	Priority *int32

	// REQUIRED; Defines rate limit duration. Default is 1 minute.
	RateLimitDurationInMinutes *int32

	// REQUIRED; Defines rate limit threshold.
	RateLimitThreshold *int32

	// Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
	EnabledState *CustomRuleEnabledState
}

// RateLimitRuleList - Defines contents of rate limit rules
type RateLimitRuleList struct {
	// List of rules
	Rules []*RateLimitRule
}

// RemoteAddressMatchConditionParameters - Defines the parameters for RemoteAddress match conditions
type RemoteAddressMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *RemoteAddressOperator

	// REQUIRED
	TypeName *RemoteAddressMatchConditionParametersTypeName

	// Match values to match against. The operator will apply to each value in here with OR semantics. If any of them match the
	// variable with the given operator this match condition is considered a match.
	MatchValues []*string

	// Describes if this is negate condition or not
	NegateCondition *bool

	// List of transforms
	Transforms []*Transform
}

// RequestBodyMatchConditionParameters - Defines the parameters for RequestBody match conditions
type RequestBodyMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *RequestBodyOperator

	// REQUIRED
	TypeName *RequestBodyMatchConditionParametersTypeName

	// The match value for the condition of the delivery rule
	MatchValues []*string

	// Describes if this is negate condition or not
	NegateCondition *bool

	// List of transforms
	Transforms []*Transform
}

// RequestHeaderMatchConditionParameters - Defines the parameters for RequestHeader match conditions
type RequestHeaderMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *RequestHeaderOperator

	// REQUIRED
	TypeName *RequestHeaderMatchConditionParametersTypeName

	// The match value for the condition of the delivery rule
	MatchValues []*string

	// Describes if this is negate condition or not
	NegateCondition *bool

	// Name of Header to be matched
	Selector *string

	// List of transforms
	Transforms []*Transform
}

// RequestMethodMatchConditionParameters - Defines the parameters for RequestMethod match conditions
type RequestMethodMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *RequestMethodOperator

	// REQUIRED
	TypeName *RequestMethodMatchConditionParametersTypeName

	// The match value for the condition of the delivery rule
	MatchValues []*RequestMethodMatchConditionParametersMatchValuesItem

	// Describes if this is negate condition or not
	NegateCondition *bool

	// List of transforms
	Transforms []*Transform
}

// RequestSchemeMatchConditionParameters - Defines the parameters for RequestScheme match conditions
type RequestSchemeMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *RequestSchemeMatchConditionParametersOperator

	// REQUIRED
	TypeName *RequestSchemeMatchConditionParametersTypeName

	// The match value for the condition of the delivery rule
	MatchValues []*RequestSchemeMatchConditionParametersMatchValuesItem

	// Describes if this is negate condition or not
	NegateCondition *bool

	// List of transforms
	Transforms []*Transform
}

// RequestURIMatchConditionParameters - Defines the parameters for RequestUri match conditions
type RequestURIMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *RequestURIOperator

	// REQUIRED
	TypeName *RequestURIMatchConditionParametersTypeName

	// The match value for the condition of the delivery rule
	MatchValues []*string

	// Describes if this is negate condition or not
	NegateCondition *bool

	// List of transforms
	Transforms []*Transform
}

// ResourceReference - Reference to another resource.
type ResourceReference struct {
	// Resource ID.
	ID *string
}

// ResourceUsage - Output of check resource usage API.
type ResourceUsage struct {
	// READ-ONLY; Actual value of usage on the specified resource type.
	CurrentValue *int32

	// READ-ONLY; Quota of the specified resource type.
	Limit *int32

	// READ-ONLY; Resource type for which the usage is provided.
	ResourceType *string

	// READ-ONLY; Unit of the usage. e.g. count.
	Unit *ResourceUsageUnit
}

// ResourceUsageListResult - Output of check resource usage API.
type ResourceUsageListResult struct {
	// URL to get the next set of custom domain objects if there are any.
	NextLink *string

	// READ-ONLY; List of resource usages.
	Value []*ResourceUsage
}

// ResourcesResponse - Resources Response
type ResourcesResponse struct {
	CustomDomains []*ResourcesResponseCustomDomainsItem
	Endpoints     []*ResourcesResponseEndpointsItem
}

type ResourcesResponseCustomDomainsItem struct {
	EndpointID *string
	History    *bool
	ID         *string
	Name       *string
}

type ResourcesResponseEndpointsItem struct {
	CustomDomains []*ResourcesResponseEndpointsPropertiesItemsItem
	History       *bool
	ID            *string
	Name          *string
}

type ResourcesResponseEndpointsPropertiesItemsItem struct {
	EndpointID *string
	History    *bool
	ID         *string
	Name       *string
}

// ResponseBasedOriginErrorDetectionParameters - The JSON object that contains the properties to determine origin health using
// real requests/responses.
type ResponseBasedOriginErrorDetectionParameters struct {
	// The list of Http status code ranges that are considered as server errors for origin and it is marked as unhealthy.
	HTTPErrorRanges []*HTTPErrorRangeParameters

	// Type of response errors for real user requests for which origin will be deemed unhealthy
	ResponseBasedDetectedErrorTypes *ResponseBasedDetectedErrorTypes

	// The percentage of failed requests in the sample where failover should trigger.
	ResponseBasedFailoverThresholdPercentage *int32
}

// Route - Friendly Routes name mapping to the any Routes or secret related information.
type Route struct {
	// The JSON object that contains the properties of the Routes to create.
	Properties *RouteProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Read only system data
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// RouteConfigurationOverrideActionParameters - Defines the parameters for the route configuration override action.
type RouteConfigurationOverrideActionParameters struct {
	// REQUIRED
	TypeName *RouteConfigurationOverrideActionParametersTypeName

	// The caching configuration associated with this rule. To disable caching, do not provide a cacheConfiguration object.
	CacheConfiguration *CacheConfiguration

	// A reference to the origin group override configuration. Leave empty to use the default origin group on route.
	OriginGroupOverride *OriginGroupOverride
}

// RouteListResult - Result of the request to list routes. It contains a list of route objects and a URL link to get the next
// set of results.
type RouteListResult struct {
	// URL to get the next set of route objects if there are any.
	NextLink *string

	// READ-ONLY; List of AzureFrontDoor routes within a profile.
	Value []*Route
}

// RouteProperties - The JSON object that contains the properties of the Routes to create.
type RouteProperties struct {
	// The caching configuration for this route. To disable caching, do not provide a cacheConfiguration object.
	CacheConfiguration *AfdRouteCacheConfiguration

	// Domains referenced by this endpoint.
	CustomDomains []*ActivatedResourceReference

	// Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
	EnabledState *EnabledState

	// Protocol this rule will use when forwarding traffic to backends.
	ForwardingProtocol *ForwardingProtocol

	// Whether to automatically redirect HTTP traffic to HTTPS traffic. Note that this is a easy way to set up this rule and it
	// will be the first rule that gets executed.
	HTTPSRedirect *HTTPSRedirect

	// whether this route will be linked to the default endpoint domain.
	LinkToDefaultDomain *LinkToDefaultDomain

	// A reference to the origin group.
	OriginGroup *ResourceReference

	// A directory path on the origin that AzureFrontDoor can use to retrieve content from, e.g. contoso.cloudapp.net/originpath.
	OriginPath *string

	// The route patterns of the rule.
	PatternsToMatch []*string

	// rule sets referenced by this endpoint.
	RuleSets []*ResourceReference

	// List of supported protocols for this route.
	SupportedProtocols []*AFDEndpointProtocols

	// READ-ONLY
	DeploymentStatus *DeploymentStatus

	// READ-ONLY; The name of the endpoint which holds the route.
	EndpointName *string

	// READ-ONLY; Provisioning status
	ProvisioningState *AfdProvisioningState
}

// RouteUpdateParameters - The domain JSON object required for domain creation or update.
type RouteUpdateParameters struct {
	// The JSON object that contains the properties of the domain to create.
	Properties *RouteUpdatePropertiesParameters
}

// RouteUpdatePropertiesParameters - The JSON object that contains the properties of the domain to create.
type RouteUpdatePropertiesParameters struct {
	// The caching configuration for this route. To disable caching, do not provide a cacheConfiguration object.
	CacheConfiguration *AfdRouteCacheConfiguration

	// Domains referenced by this endpoint.
	CustomDomains []*ActivatedResourceReference

	// Whether to enable use of this rule. Permitted values are 'Enabled' or 'Disabled'
	EnabledState *EnabledState

	// Protocol this rule will use when forwarding traffic to backends.
	ForwardingProtocol *ForwardingProtocol

	// Whether to automatically redirect HTTP traffic to HTTPS traffic. Note that this is a easy way to set up this rule and it
	// will be the first rule that gets executed.
	HTTPSRedirect *HTTPSRedirect

	// whether this route will be linked to the default endpoint domain.
	LinkToDefaultDomain *LinkToDefaultDomain

	// A reference to the origin group.
	OriginGroup *ResourceReference

	// A directory path on the origin that AzureFrontDoor can use to retrieve content from, e.g. contoso.cloudapp.net/originpath.
	OriginPath *string

	// The route patterns of the rule.
	PatternsToMatch []*string

	// rule sets referenced by this endpoint.
	RuleSets []*ResourceReference

	// List of supported protocols for this route.
	SupportedProtocols []*AFDEndpointProtocols

	// READ-ONLY; The name of the endpoint which holds the route.
	EndpointName *string
}

// Rule - Friendly Rules name mapping to the any Rules or secret related information.
type Rule struct {
	// The JSON object that contains the properties of the Rules to create.
	Properties *RuleProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Read only system data
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// RuleListResult - Result of the request to list rules. It contains a list of rule objects and a URL link to get the next
// set of results.
type RuleListResult struct {
	// URL to get the next set of rule objects if there are any.
	NextLink *string

	// READ-ONLY; List of AzureFrontDoor rules within a rule set.
	Value []*Rule
}

// RuleProperties - The JSON object that contains the properties of the Rules to create.
type RuleProperties struct {
	// A list of actions that are executed when all the conditions of a rule are satisfied.
	Actions []DeliveryRuleActionAutoGeneratedClassification

	// A list of conditions that must be matched for the actions to be executed
	Conditions []DeliveryRuleConditionClassification

	// If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults
	// to Continue.
	MatchProcessingBehavior *MatchProcessingBehavior

	// The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will
	// be applied before a rule with a greater order. Rule with order 0 is a special
	// rule. It does not require any condition and actions listed in it will always be applied.
	Order *int32

	// READ-ONLY
	DeploymentStatus *DeploymentStatus

	// READ-ONLY; Provisioning status
	ProvisioningState *AfdProvisioningState

	// READ-ONLY; The name of the rule set containing the rule.
	RuleSetName *string
}

// RuleSet - Friendly RuleSet name mapping to the any RuleSet or secret related information.
type RuleSet struct {
	// The JSON object that contains the properties of the Rule Set to create.
	Properties *RuleSetProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Read only system data
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// RuleSetListResult - Result of the request to list rule sets. It contains a list of rule set objects and a URL link to get
// the next set of results.
type RuleSetListResult struct {
	// URL to get the next set of rule set objects if there are any.
	NextLink *string

	// READ-ONLY; List of AzureFrontDoor rule sets within a profile.
	Value []*RuleSet
}

// RuleSetProperties - The JSON object that contains the properties of the Rule Set to create.
type RuleSetProperties struct {
	// READ-ONLY
	DeploymentStatus *DeploymentStatus

	// READ-ONLY; The name of the profile which holds the rule set.
	ProfileName *string

	// READ-ONLY; Provisioning status
	ProvisioningState *AfdProvisioningState
}

// RuleUpdateParameters - The domain JSON object required for domain creation or update.
type RuleUpdateParameters struct {
	// The JSON object that contains the properties of the rule to update.
	Properties *RuleUpdatePropertiesParameters
}

// RuleUpdatePropertiesParameters - The JSON object that contains the properties of the rule to update.
type RuleUpdatePropertiesParameters struct {
	// A list of actions that are executed when all the conditions of a rule are satisfied.
	Actions []DeliveryRuleActionAutoGeneratedClassification

	// A list of conditions that must be matched for the actions to be executed
	Conditions []DeliveryRuleConditionClassification

	// If this rule is a match should the rules engine continue running the remaining rules or stop. If not present, defaults
	// to Continue.
	MatchProcessingBehavior *MatchProcessingBehavior

	// The order in which the rules are applied for the endpoint. Possible values {0,1,2,3,………}. A rule with a lesser order will
	// be applied before a rule with a greater order. Rule with order 0 is a special
	// rule. It does not require any condition and actions listed in it will always be applied.
	Order *int32

	// READ-ONLY; The name of the rule set containing the rule.
	RuleSetName *string
}

// SKU - StandardVerizon = The SKU name for a Standard Verizon CDN profile. PremiumVerizon = The SKU name for a Premium Verizon
// CDN profile. CustomVerizon = The SKU name for a Custom Verizon CDN profile.
// StandardAkamai = The SKU name for an Akamai CDN profile. StandardChinaCdn = The SKU name for a China CDN profile for VOD,
// Web and download scenarios using GB based billing model. StandardMicrosoft =
// The SKU name for a Standard Microsoft CDN profile. StandardAzureFrontDoor = The SKU name for an Azure Front Door Standard
// profile. PremiumAzureFrontDoor = The SKU name for an Azure Front Door Premium
// profile. Standard955BandWidthChinaCdn = The SKU name for a China CDN profile for VOD, Web and download scenarios using
// 95-5 peak bandwidth billing model. StandardAvgBandWidthChinaCdn = The SKU name
// for a China CDN profile for VOD, Web and download scenarios using monthly average peak bandwidth billing model. StandardPlusChinaCdn
// = The SKU name for a China CDN profile for live-streaming using GB
// based billing model. StandardPlus955BandWidthChinaCdn = The SKU name for a China CDN live-streaming profile using 95-5
// peak bandwidth billing model. StandardPlusAvgBandWidth_ChinaCdn = The SKU name
// for a China CDN live-streaming profile using monthly average peak bandwidth billing model.
type SKU struct {
	// Name of the pricing tier.
	Name *SKUName
}

// SSLProtocolMatchConditionParameters - Defines the parameters for SslProtocol match conditions
type SSLProtocolMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *SSLProtocolOperator

	// REQUIRED
	TypeName *SSLProtocolMatchConditionParametersTypeName

	// The match value for the condition of the delivery rule
	MatchValues []*SSLProtocol

	// Describes if this is negate condition or not
	NegateCondition *bool

	// List of transforms
	Transforms []*Transform
}

// Secret - Friendly Secret name mapping to the any Secret or secret related information.
type Secret struct {
	// The JSON object that contains the properties of the Secret to create.
	Properties *SecretProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Read only system data
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// SecretListResult - Result of the request to list secrets. It contains a list of Secret objects and a URL link to get the
// next set of results.
type SecretListResult struct {
	// URL to get the next set of Secret objects if there are any.
	NextLink *string

	// READ-ONLY; List of AzureFrontDoor secrets within a profile.
	Value []*Secret
}

// SecretParameters - The json object containing secret parameters
type SecretParameters struct {
	// REQUIRED; The type of the secret resource.
	Type *SecretType
}

// GetSecretParameters implements the SecretParametersClassification interface for type SecretParameters.
func (s *SecretParameters) GetSecretParameters() *SecretParameters { return s }

// SecretProperties - The JSON object that contains the properties of the Secret to create.
type SecretProperties struct {
	// object which contains secret parameters
	Parameters SecretParametersClassification

	// READ-ONLY
	DeploymentStatus *DeploymentStatus

	// READ-ONLY; The name of the profile which holds the secret.
	ProfileName *string

	// READ-ONLY; Provisioning status
	ProvisioningState *AfdProvisioningState
}

// SecurityPolicy association for AzureFrontDoor profile
type SecurityPolicy struct {
	// The json object that contains properties required to create a security policy
	Properties *SecurityPolicyProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Read only system data
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// SecurityPolicyListResult - Result of the request to list security policies. It contains a list of security policy objects
// and a URL link to get the next set of results.
type SecurityPolicyListResult struct {
	// URL to get the next set of security policy objects if there is any.
	NextLink *string

	// READ-ONLY; List of Security policies within a profile
	Value []*SecurityPolicy
}

// SecurityPolicyProperties - The json object that contains properties required to create a security policy
type SecurityPolicyProperties struct {
	// object which contains security policy parameters
	Parameters SecurityPolicyPropertiesParametersClassification

	// READ-ONLY
	DeploymentStatus *DeploymentStatus

	// READ-ONLY; The name of the profile which holds the security policy.
	ProfileName *string

	// READ-ONLY; Provisioning status
	ProvisioningState *AfdProvisioningState
}

// SecurityPolicyPropertiesParameters - The json object containing security policy parameters
type SecurityPolicyPropertiesParameters struct {
	// REQUIRED; The type of the Security policy to create.
	Type *SecurityPolicyType
}

// GetSecurityPolicyPropertiesParameters implements the SecurityPolicyPropertiesParametersClassification interface for type
// SecurityPolicyPropertiesParameters.
func (s *SecurityPolicyPropertiesParameters) GetSecurityPolicyPropertiesParameters() *SecurityPolicyPropertiesParameters {
	return s
}

// SecurityPolicyUpdateParameters - The JSON object containing security policy update parameters.
type SecurityPolicyUpdateParameters struct {
	// The json object that contains properties required to update a security policy
	Properties *SecurityPolicyUpdateProperties
}

// SecurityPolicyUpdateProperties - The json object that contains properties required to update a security policy
type SecurityPolicyUpdateProperties struct {
	// object which contains security policy parameters
	Parameters SecurityPolicyPropertiesParametersClassification
}

// SecurityPolicyWebApplicationFirewallAssociation - settings for security policy patterns to match
type SecurityPolicyWebApplicationFirewallAssociation struct {
	// List of domains.
	Domains []*ActivatedResourceReference

	// List of paths
	PatternsToMatch []*string
}

// SecurityPolicyWebApplicationFirewallParameters - The json object containing security policy waf parameters
type SecurityPolicyWebApplicationFirewallParameters struct {
	// REQUIRED; The type of the Security policy to create.
	Type *SecurityPolicyType

	// Waf associations
	Associations []*SecurityPolicyWebApplicationFirewallAssociation

	// Resource ID.
	WafPolicy *ResourceReference
}

// GetSecurityPolicyPropertiesParameters implements the SecurityPolicyPropertiesParametersClassification interface for type
// SecurityPolicyWebApplicationFirewallParameters.
func (s *SecurityPolicyWebApplicationFirewallParameters) GetSecurityPolicyPropertiesParameters() *SecurityPolicyPropertiesParameters {
	return &SecurityPolicyPropertiesParameters{
		Type: s.Type,
	}
}

// ServerPortMatchConditionParameters - Defines the parameters for ServerPort match conditions
type ServerPortMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *ServerPortOperator

	// REQUIRED
	TypeName *ServerPortMatchConditionParametersTypeName

	// The match value for the condition of the delivery rule
	MatchValues []*string

	// Describes if this is negate condition or not
	NegateCondition *bool

	// List of transforms
	Transforms []*Transform
}

// ServiceSpecification - One property of operation, include log specifications.
type ServiceSpecification struct {
	// Log specifications of operation.
	LogSpecifications []*LogSpecification

	// Metric specifications of operation.
	MetricSpecifications []*MetricSpecification
}

// SharedPrivateLinkResourceProperties - Describes the properties of an existing Shared Private Link Resource to use when
// connecting to a private origin.
type SharedPrivateLinkResourceProperties struct {
	// The group id from the provider of resource the shared private link resource is for.
	GroupID *string

	// The resource id of the resource the shared private link resource is for.
	PrivateLink *ResourceReference

	// The location of the shared private link resource
	PrivateLinkLocation *string

	// The request message for requesting approval of the shared private link resource.
	RequestMessage *string

	// Status of the shared private link resource. Can be Pending, Approved, Rejected, Disconnected, or Timeout.
	Status *SharedPrivateLinkResourceStatus
}

// SocketAddrMatchConditionParameters - Defines the parameters for SocketAddress match conditions
type SocketAddrMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *SocketAddrOperator

	// REQUIRED
	TypeName *SocketAddrMatchConditionParametersTypeName

	// The match value for the condition of the delivery rule
	MatchValues []*string

	// Describes if this is negate condition or not
	NegateCondition *bool

	// List of transforms
	Transforms []*Transform
}

// SsoURI - The URI required to login to the supplemental portal from the Azure portal.
type SsoURI struct {
	// READ-ONLY; The URI used to login to the supplemental portal.
	SsoURIValue *string
}

// SupportedOptimizationTypesListResult - The result of the GetSupportedOptimizationTypes API
type SupportedOptimizationTypesListResult struct {
	// READ-ONLY; Supported optimization types for a profile.
	SupportedOptimizationTypes []*OptimizationType
}

// SystemData - Read only system data
type SystemData struct {
	// The timestamp of resource creation (UTC)
	CreatedAt *time.Time

	// An identifier for the identity that created the resource
	CreatedBy *string

	// The type of identity that created the resource
	CreatedByType *IdentityType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// An identifier for the identity that last modified the resource
	LastModifiedBy *string

	// The type of identity that last modified the resource
	LastModifiedByType *IdentityType
}

// URLFileExtensionMatchConditionParameters - Defines the parameters for UrlFileExtension match conditions
type URLFileExtensionMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *URLFileExtensionOperator

	// REQUIRED
	TypeName *URLFileExtensionMatchConditionParametersTypeName

	// The match value for the condition of the delivery rule
	MatchValues []*string

	// Describes if this is negate condition or not
	NegateCondition *bool

	// List of transforms
	Transforms []*Transform
}

// URLFileNameMatchConditionParameters - Defines the parameters for UrlFilename match conditions
type URLFileNameMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *URLFileNameOperator

	// REQUIRED
	TypeName *URLFileNameMatchConditionParametersTypeName

	// The match value for the condition of the delivery rule
	MatchValues []*string

	// Describes if this is negate condition or not
	NegateCondition *bool

	// List of transforms
	Transforms []*Transform
}

// URLPathMatchConditionParameters - Defines the parameters for UrlPath match conditions
type URLPathMatchConditionParameters struct {
	// REQUIRED; Describes operator to be matched
	Operator *URLPathOperator

	// REQUIRED
	TypeName *URLPathMatchConditionParametersTypeName

	// The match value for the condition of the delivery rule
	MatchValues []*string

	// Describes if this is negate condition or not
	NegateCondition *bool

	// List of transforms
	Transforms []*Transform
}

// URLRedirectAction - Defines the url redirect action for the delivery rule.
type URLRedirectAction struct {
	// REQUIRED; The name of the action for the delivery rule.
	Name *DeliveryRuleAction

	// REQUIRED; Defines the parameters for the action.
	Parameters *URLRedirectActionParameters
}

// GetDeliveryRuleActionAutoGenerated implements the DeliveryRuleActionAutoGeneratedClassification interface for type URLRedirectAction.
func (u *URLRedirectAction) GetDeliveryRuleActionAutoGenerated() *DeliveryRuleActionAutoGenerated {
	return &DeliveryRuleActionAutoGenerated{
		Name: u.Name,
	}
}

// URLRedirectActionParameters - Defines the parameters for the url redirect action.
type URLRedirectActionParameters struct {
	// REQUIRED; The redirect type the rule will use when redirecting traffic.
	RedirectType *RedirectType

	// REQUIRED
	TypeName *URLRedirectActionParametersTypeName

	// Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #.
	CustomFragment *string

	// Host to redirect. Leave empty to use the incoming host as the destination host.
	CustomHostname *string

	// The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination
	// path.
	CustomPath *string

	// The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string;
	// leave empty to preserve the incoming query string. Query string must be in =
	// format. ? and & will be added automatically so do not include them.
	CustomQueryString *string

	// Protocol to use for the redirect. The default value is MatchRequest
	DestinationProtocol *DestinationProtocol
}

// URLRewriteAction - Defines the url rewrite action for the delivery rule.
type URLRewriteAction struct {
	// REQUIRED; The name of the action for the delivery rule.
	Name *DeliveryRuleAction

	// REQUIRED; Defines the parameters for the action.
	Parameters *URLRewriteActionParameters
}

// GetDeliveryRuleActionAutoGenerated implements the DeliveryRuleActionAutoGeneratedClassification interface for type URLRewriteAction.
func (u *URLRewriteAction) GetDeliveryRuleActionAutoGenerated() *DeliveryRuleActionAutoGenerated {
	return &DeliveryRuleActionAutoGenerated{
		Name: u.Name,
	}
}

// URLRewriteActionParameters - Defines the parameters for the url rewrite action.
type URLRewriteActionParameters struct {
	// REQUIRED; Define the relative URL to which the above requests will be rewritten by.
	Destination *string

	// REQUIRED; define a request URI pattern that identifies the type of requests that may be rewritten. If value is blank, all
	// strings are matched.
	SourcePattern *string

	// REQUIRED
	TypeName *URLRewriteActionParametersTypeName

	// Whether to preserve unmatched path. Default value is true.
	PreserveUnmatchedPath *bool
}

// URLSigningAction - Defines the url signing action for the delivery rule.
type URLSigningAction struct {
	// REQUIRED; The name of the action for the delivery rule.
	Name *DeliveryRuleAction

	// REQUIRED; Defines the parameters for the action.
	Parameters *URLSigningActionParameters
}

// GetDeliveryRuleActionAutoGenerated implements the DeliveryRuleActionAutoGeneratedClassification interface for type URLSigningAction.
func (u *URLSigningAction) GetDeliveryRuleActionAutoGenerated() *DeliveryRuleActionAutoGenerated {
	return &DeliveryRuleActionAutoGenerated{
		Name: u.Name,
	}
}

// URLSigningActionParameters - Defines the parameters for the Url Signing action.
type URLSigningActionParameters struct {
	// REQUIRED
	TypeName *URLSigningActionParametersTypeName

	// Algorithm to use for URL signing
	Algorithm *Algorithm

	// Defines which query string parameters in the url to be considered for expires, key id etc.
	ParameterNameOverride []*URLSigningParamIdentifier
}

// URLSigningKey - Url signing key
type URLSigningKey struct {
	// REQUIRED; Defines the customer defined key Id. This id will exist in the incoming request to indicate the key used to form
	// the hash.
	KeyID *string

	// REQUIRED; Defines the parameters for using customer key vault for Url Signing Key.
	KeySourceParameters *KeyVaultSigningKeyParameters
}

// URLSigningKeyParameters - Url signing key parameters
type URLSigningKeyParameters struct {
	// REQUIRED; Defines the customer defined key Id. This id will exist in the incoming request to indicate the key used to form
	// the hash.
	KeyID *string

	// REQUIRED; Resource reference to the Azure Key Vault secret. Expected to be in format of
	// /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{secretName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​
	SecretSource *ResourceReference

	// REQUIRED; The type of the secret resource.
	Type *SecretType

	// Version of the secret to be used
	SecretVersion *string
}

// GetSecretParameters implements the SecretParametersClassification interface for type URLSigningKeyParameters.
func (u *URLSigningKeyParameters) GetSecretParameters() *SecretParameters {
	return &SecretParameters{
		Type: u.Type,
	}
}

// URLSigningParamIdentifier - Defines how to identify a parameter for a specific purpose e.g. expires
type URLSigningParamIdentifier struct {
	// REQUIRED; Indicates the purpose of the parameter
	ParamIndicator *ParamIndicator

	// REQUIRED; Parameter name
	ParamName *string
}

// Usage - Describes resource usage.
type Usage struct {
	// REQUIRED; The current value of the usage.
	CurrentValue *int64

	// REQUIRED; The limit of usage.
	Limit *int64

	// REQUIRED; The name of the type of usage.
	Name *UsageName

	// REQUIRED; An enum describing the unit of measurement.
	Unit *UsageUnit

	// READ-ONLY; Resource identifier.
	ID *string
}

// UsageName - The usage names.
type UsageName struct {
	// A localized string describing the resource name.
	LocalizedValue *string

	// A string describing the resource name.
	Value *string
}

// UsagesListResult - The list usages operation response.
type UsagesListResult struct {
	// URL to get the next set of results.
	NextLink *string

	// The list of resource usages.
	Value []*Usage
}

// UserAssignedIdentity - User assigned identity properties
type UserAssignedIdentity struct {
	// READ-ONLY; The client ID of the assigned identity.
	ClientID *string

	// READ-ONLY; The principal ID of the assigned identity.
	PrincipalID *string
}

// UserManagedHTTPSParameters - Defines the certificate source parameters using user's keyvault certificate for enabling SSL.
type UserManagedHTTPSParameters struct {
	// REQUIRED; Defines the source of the SSL certificate.
	CertificateSource *CertificateSource

	// REQUIRED; Defines the certificate source parameters using user's keyvault certificate for enabling SSL.
	CertificateSourceParameters *KeyVaultCertificateSourceParameters

	// REQUIRED; Defines the TLS extension protocol that is used for secure delivery.
	ProtocolType *ProtocolType

	// TLS protocol version that will be used for Https
	MinimumTLSVersion *MinimumTLSVersion
}

// GetCustomDomainHTTPSParameters implements the CustomDomainHTTPSParametersClassification interface for type UserManagedHTTPSParameters.
func (u *UserManagedHTTPSParameters) GetCustomDomainHTTPSParameters() *CustomDomainHTTPSParameters {
	return &CustomDomainHTTPSParameters{
		CertificateSource: u.CertificateSource,
		MinimumTLSVersion: u.MinimumTLSVersion,
		ProtocolType:      u.ProtocolType,
	}
}

// ValidateCustomDomainInput - Input of the custom domain to be validated for DNS mapping.
type ValidateCustomDomainInput struct {
	// REQUIRED; The host name of the custom domain. Must be a domain name.
	HostName *string
}

// ValidateCustomDomainOutput - Output of custom domain validation.
type ValidateCustomDomainOutput struct {
	// READ-ONLY; Indicates whether the custom domain is valid or not.
	CustomDomainValidated *bool

	// READ-ONLY; Error message describing why the custom domain is not valid.
	Message *string

	// READ-ONLY; The reason why the custom domain is not valid.
	Reason *string
}

// ValidateProbeInput - Input of the validate probe API.
type ValidateProbeInput struct {
	// REQUIRED; The probe URL to validate.
	ProbeURL *string
}

// ValidateProbeOutput - Output of the validate probe API.
type ValidateProbeOutput struct {
	// READ-ONLY; Specifies the error code when the probe url is not accepted.
	ErrorCode *string

	// READ-ONLY; Indicates whether the probe URL is accepted or not.
	IsValid *bool

	// READ-ONLY; The detailed error message describing why the probe URL is not accepted.
	Message *string
}

// ValidateSecretInput - Input of the secret to be validated.
type ValidateSecretInput struct {
	// REQUIRED; Resource reference to the Azure Key Vault secret. Expected to be in format of
	// /subscriptions/{​​​​​​​​​subscriptionId}​​​​​​​​​/resourceGroups/{​​​​​​​​​resourceGroupName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/providers/Microsoft.KeyVault/vaults/{vaultName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​/secrets/{secretName}​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​​
	SecretSource *ResourceReference

	// REQUIRED; The secret type.
	SecretType *SecretType

	// Secret version, if customer is using a specific version.
	SecretVersion *string
}

// ValidateSecretOutput - Output of the validated secret.
type ValidateSecretOutput struct {
	// Detailed error message
	Message *string

	// The validation status.
	Status *Status
}

// WafMetricsResponse - Waf Metrics Response
type WafMetricsResponse struct {
	DateTimeBegin *time.Time
	DateTimeEnd   *time.Time
	Granularity   *WafMetricsGranularity
	Series        []*WafMetricsResponseSeriesItem
}

type WafMetricsResponseSeriesItem struct {
	Data   []*Components18OrqelSchemasWafmetricsresponsePropertiesSeriesItemsPropertiesDataItems
	Groups []*WafMetricsResponseSeriesPropertiesItemsItem
	Metric *string
	Unit   *WafMetricsSeriesUnit
}

type WafMetricsResponseSeriesPropertiesItemsItem struct {
	Name  *string
	Value *string
}

// WafRankingsResponse - Waf Rankings Response
type WafRankingsResponse struct {
	Data          []*WafRankingsResponseDataItem
	DateTimeBegin *time.Time
	DateTimeEnd   *time.Time
	Groups        []*string
}

type WafRankingsResponseDataItem struct {
	GroupValues []*string
	Metrics     []*ComponentsKpo1PjSchemasWafrankingsresponsePropertiesDataItemsPropertiesMetricsItems
}

// WebApplicationFirewallPolicy - Defines web application firewall policy for Azure CDN.
type WebApplicationFirewallPolicy struct {
	// REQUIRED; Resource location.
	Location *string

	// REQUIRED; The pricing tier (defines a CDN provider, feature list and rate) of the CdnWebApplicationFirewallPolicy.
	SKU *SKU

	// Gets a unique read-only string that changes whenever the resource is updated.
	Etag *string

	// Properties of the web application firewall policy.
	Properties *WebApplicationFirewallPolicyProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Read only system data
	SystemData *SystemData

	// READ-ONLY; Resource type.
	Type *string
}

// WebApplicationFirewallPolicyList - Defines a list of WebApplicationFirewallPolicies for Azure CDN. It contains a list of
// WebApplicationFirewallPolicy objects and a URL link to get the next set of results.
type WebApplicationFirewallPolicyList struct {
	// URL to get the next set of WebApplicationFirewallPolicy objects if there are any.
	NextLink *string

	// READ-ONLY; List of Azure CDN WebApplicationFirewallPolicies within a resource group.
	Value []*WebApplicationFirewallPolicy
}

// WebApplicationFirewallPolicyPatchParameters - Properties required to update a CdnWebApplicationFirewallPolicy.
type WebApplicationFirewallPolicyPatchParameters struct {
	// CdnWebApplicationFirewallPolicy tags
	Tags map[string]*string
}

// WebApplicationFirewallPolicyProperties - Defines CDN web application firewall policy properties.
type WebApplicationFirewallPolicyProperties struct {
	// Describes custom rules inside the policy.
	CustomRules *CustomRuleList

	// Key-Value pair representing additional properties for Web Application Firewall policy.
	ExtendedProperties map[string]*string

	// Describes managed rules inside the policy.
	ManagedRules *ManagedRuleSetList

	// Describes policySettings for policy
	PolicySettings *PolicySettings

	// Describes rate limit rules inside the policy.
	RateLimitRules *RateLimitRuleList

	// READ-ONLY; Describes Azure CDN endpoints associated with this Web Application Firewall policy.
	EndpointLinks []*LinkedEndpoint

	// READ-ONLY; Provisioning state of the WebApplicationFirewallPolicy.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Resource status of the policy.
	ResourceState *PolicyResourceState
}
